/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogisticDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="Robust Estimators for Transformed Location Scale Families", authors="D. J. Olive", booktitle="", bibkey="preprints/Olive06")
public class LogisticMADEstimator
implements MADDistributionEstimator<LogisticDistribution> {
    public static final LogisticMADEstimator STATIC = new LogisticMADEstimator();

    private LogisticMADEstimator() {
    }

    @Override
    public LogisticDistribution estimateFromMedianMAD(double median, double mad) {
        return new LogisticDistribution(median, mad / MathUtil.LOG3);
    }

    @Override
    public Class<? super LogisticDistribution> getDistributionClass() {
        return LogisticDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogisticMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

