/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;

public interface MADDistributionEstimator<D extends Distribution>
extends DistributionEstimator<D> {
    public D estimateFromMedianMAD(double var1, double var3);

    @Override
    default public <A> D estimate(A data, NumberArrayAdapter<?, A> adapter) {
        int len = adapter.size(data);
        double[] x = new double[len];
        for (int i = 0; i < len; ++i) {
            x[i] = adapter.getDouble(data, i);
        }
        double median = QuickSelect.median(x);
        double mad = MADDistributionEstimator.computeMAD(x, x.length, median);
        return this.estimateFromMedianMAD(median, mad);
    }

    public static double computeMAD(double[] data, int len, double median, double[] scratch) {
        for (int i = 0; i < len; ++i) {
            scratch[i] = Math.abs(data[i] - median);
        }
        double mad = QuickSelect.median(scratch);
        if (!(mad > 0.0)) {
            double min = Double.POSITIVE_INFINITY;
            for (int i = len >> 1; i < len; ++i) {
                min = scratch[i] > 0.0 && scratch[i] < min ? scratch[i] : min;
            }
            mad = min < Double.POSITIVE_INFINITY ? min : 1.0;
        }
        return mad;
    }

    public static double computeMAD(double[] x, int len, double median) {
        for (int i = 0; i < len; ++i) {
            x[i] = Math.abs(x[i] - median);
        }
        double mad = QuickSelect.median(x);
        if (!(mad > 0.0)) {
            double min = Double.POSITIVE_INFINITY;
            for (int i = 0; i < len; ++i) {
                double xi = x[i];
                min = xi > 0.0 && xi < min ? xi : min;
            }
            mad = min < Double.POSITIVE_INFINITY ? min : 1.0;
        }
        return mad;
    }
}

