/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J. R. M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report", bibkey="tr/ibm/Hosking00")
public class NormalLMMEstimator
implements LMMDistributionEstimator<NormalDistribution> {
    public static final NormalLMMEstimator STATIC = new NormalLMMEstimator();

    private NormalLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public NormalDistribution estimateFromLMoments(double[] xmom) {
        return new NormalDistribution(xmom[0], Math.max(xmom[1] * MathUtil.SQRTPI, Double.MIN_NORMAL));
    }

    @Override
    public Class<? super NormalDistribution> getDistributionClass() {
        return NormalDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected NormalLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

