/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.RayleighDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class RayleighLMMEstimator
implements LMMDistributionEstimator<RayleighDistribution> {
    public static final RayleighLMMEstimator STATIC = new RayleighLMMEstimator();

    private RayleighLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public RayleighDistribution estimateFromLMoments(double[] xmom) {
        double sigma = 2.0 * xmom[1] / (MathUtil.SQRTPI * (MathUtil.SQRT2 - 1.0));
        double mu = xmom[0] - sigma * MathUtil.SQRTHALFPI;
        return new RayleighDistribution(mu, sigma);
    }

    @Override
    public Class<? super RayleighDistribution> getDistributionClass() {
        return RayleighDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RayleighLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

