/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.RayleighDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="D. J. Olive", title="Applied Robust Statistics", booktitle="", url="http://lagrange.math.siu.edu/Olive/preprints.htm", bibkey="books/Olive08")
public class RayleighMADEstimator
implements MADDistributionEstimator<RayleighDistribution> {
    public static final RayleighMADEstimator STATIC = new RayleighMADEstimator();
    private static final double F1 = 2.2298880819171685;
    private static final double F2 = 2.6254925265300937;

    private RayleighMADEstimator() {
    }

    @Override
    public RayleighDistribution estimateFromMedianMAD(double median, double mad) {
        return new RayleighDistribution(median - 2.6254925265300937 * mad, 2.2298880819171685 * mad);
    }

    @Override
    public Class<? super RayleighDistribution> getDistributionClass() {
        return RayleighDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RayleighMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

