/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.RayleighDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class RayleighMLEEstimator
implements DistributionEstimator<RayleighDistribution> {
    public static final RayleighMLEEstimator STATIC = new RayleighMLEEstimator();

    private RayleighMLEEstimator() {
    }

    @Override
    public <A> RayleighDistribution estimate(A data, NumberArrayAdapter<?, A> adapter) {
        int len = adapter.size(data);
        double sumsq = 0.0;
        for (int i = 0; i < len; ++i) {
            double v = adapter.getDouble(data, i);
            sumsq += v * v;
        }
        return new RayleighDistribution(Math.sqrt(0.5 * sumsq / (double)len));
    }

    @Override
    public Class<? super RayleighDistribution> getDistributionClass() {
        return RayleighDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RayleighMLEEstimator makeInstance() {
            return STATIC;
        }
    }
}

