/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class UniformEnhancedMinMaxEstimator
implements DistributionEstimator<UniformDistribution> {
    public static final UniformEnhancedMinMaxEstimator STATIC = new UniformEnhancedMinMaxEstimator();

    private UniformEnhancedMinMaxEstimator() {
    }

    @Override
    public <A> UniformDistribution estimate(A data, NumberArrayAdapter<?, A> adapter) {
        int len = adapter.size(data);
        DoubleMinMax mm = new DoubleMinMax();
        for (int i = 0; i < len; ++i) {
            double val = adapter.getDouble(data, i);
            if (!(val > Double.NEGATIVE_INFINITY) || !(val < Double.POSITIVE_INFINITY)) continue;
            mm.put(val);
        }
        return this.estimate(mm.getMin(), mm.getMax(), len);
    }

    public UniformDistribution estimate(double min, double max, int count) {
        double grow = count > 1 ? 0.5 * (max - min) / (double)(count - 1) : 0.0;
        return new UniformDistribution(Math.max(min - grow, -1.7976931348623157E308), Math.min(max + grow, Double.MAX_VALUE));
    }

    @Override
    public Class<? super UniformDistribution> getDistributionClass() {
        return UniformDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected UniformEnhancedMinMaxEstimator makeInstance() {
            return STATIC;
        }
    }
}

