/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class UniformLMMEstimator
implements LMMDistributionEstimator<UniformDistribution> {
    public static final UniformLMMEstimator STATIC = new UniformLMMEstimator();

    private UniformLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public UniformDistribution estimateFromLMoments(double[] xmom) {
        return new UniformDistribution(Math.max(xmom[0] - 3.0 * xmom[1], -1.7976931348623157E308), Math.min(xmom[0] + 3.0 * xmom[1], Double.MAX_VALUE));
    }

    @Override
    public Class<? super UniformDistribution> getDistributionClass() {
        return UniformDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected UniformLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

