/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="D. J. Olive", title="Applied Robust Statistics", booktitle="", url="http://lagrange.math.siu.edu/Olive/preprints.htm", bibkey="books/Olive08")
public class UniformMADEstimator
implements MADDistributionEstimator<UniformDistribution> {
    public static final UniformMADEstimator STATIC = new UniformMADEstimator();

    private UniformMADEstimator() {
    }

    @Override
    public UniformDistribution estimateFromMedianMAD(double median, double mad) {
        return new UniformDistribution(Math.max(median - 2.0 * mad, -1.7976931348623157E308), Math.min(median + 2.0 * mad, Double.MAX_VALUE));
    }

    @Override
    public Class<? super UniformDistribution> getDistributionClass() {
        return UniformDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected UniformMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

