/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class UniformMinMaxEstimator
implements DistributionEstimator<UniformDistribution> {
    public static final UniformMinMaxEstimator STATIC = new UniformMinMaxEstimator();

    private UniformMinMaxEstimator() {
    }

    @Override
    public <A> UniformDistribution estimate(A data, NumberArrayAdapter<?, A> adapter) {
        int len = adapter.size(data);
        DoubleMinMax mm = new DoubleMinMax();
        for (int i = 0; i < len; ++i) {
            double val = adapter.getDouble(data, i);
            if (!(val > Double.NEGATIVE_INFINITY) || !(val < Double.POSITIVE_INFINITY)) continue;
            mm.put(val);
        }
        return this.estimate(mm);
    }

    public UniformDistribution estimate(DoubleMinMax mm) {
        return new UniformDistribution(Math.max(mm.getMin(), -1.7976931348623157E308), Math.min(mm.getMax(), Double.MAX_VALUE));
    }

    public Distribution estimate(double min, double max) {
        return new UniformDistribution(min, max);
    }

    @Override
    public Class<? super UniformDistribution> getDistributionClass() {
        return UniformDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected UniformMinMaxEstimator makeInstance() {
            return STATIC;
        }
    }
}

