/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.WeibullDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

public class WeibullLMMEstimator
implements LMMDistributionEstimator<WeibullDistribution> {
    public static final WeibullLMMEstimator STATIC = new WeibullLMMEstimator();
    private static final double A0 = 0.2837753;
    private static final double A1 = -1.21096399;
    private static final double A2 = -2.50728214;
    private static final double A3 = -1.13455566;
    private static final double A4 = -0.07138022;
    private static final double B1 = 2.06189696;
    private static final double B2 = 1.31912239;
    private static final double B3 = 0.25077104;
    private static final double C1 = 1.59921491;
    private static final double C2 = -0.48832213;
    private static final double C3 = 0.01573152;
    private static final double D1 = -0.64363929;
    private static final double D2 = 0.08985247;
    static int MAXIT = 20;

    private WeibullLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public WeibullDistribution estimateFromLMoments(double[] xmom) {
        double g;
        double t3 = -xmom[2];
        if (Math.abs(t3) < 1.0E-50 || t3 >= 1.0) {
            throw new ArithmeticException("Invalid moment estimation.");
        }
        if (t3 > 0.0) {
            double z = 1.0 - t3;
            g = (-1.0 + z * (1.59921491 + z * (-0.48832213 + z * 0.01573152))) / (1.0 + z * (-0.64363929 + z * 0.08985247));
        } else {
            g = (0.2837753 + t3 * (-1.21096399 + t3 * (-2.50728214 + t3 * (-1.13455566 + t3 * -0.07138022)))) / (1.0 + t3 * (2.06189696 + t3 * (1.31912239 + t3 * 0.25077104)));
            if (t3 < -0.8) {
                if (t3 <= -0.97) {
                    g = 1.0 - FastMath.log1p(t3) * MathUtil.ONE_BY_LOG2;
                }
                double t0 = 0.5 * (t3 + 3.0);
                int it = 1;
                while (true) {
                    double oldg;
                    double deriv;
                    double x3;
                    double xx3;
                    double t;
                    double x2 = FastMath.pow(2.0, -g);
                    double xx2 = 1.0 - x2;
                    if (Math.abs((g -= ((t = (xx3 = 1.0 - (x3 = FastMath.pow(3.0, -g))) / xx2) - t0) / (deriv = (xx2 * x3 * MathUtil.LOG3 - xx3 * x2 * MathUtil.LOG2) / (xx2 * xx2))) - (oldg = g)) < 1.0E-14 * g) break;
                    if (it >= MAXIT) {
                        throw new ArithmeticException("Newton-Raphson did not converge.");
                    }
                    ++it;
                }
            }
        }
        double gam = FastMath.exp(GammaDistribution.logGamma(1.0 + g));
        double k = 1.0 / g;
        double sigma = xmom[1] / (gam * (1.0 - FastMath.pow(2.0, -g)));
        double mu = -xmom[0] + sigma * gam;
        return new WeibullDistribution(k, sigma, mu);
    }

    @Override
    public Class<? super WeibullDistribution> getDistributionClass() {
        return WeibullDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected WeibullLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

