/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.WeibullDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogMADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="D. J. Olive", title="Applied Robust Statistics", booktitle="", url="http://lagrange.math.siu.edu/Olive/preprints.htm", bibkey="books/Olive08")
public class WeibullLogMADEstimator
implements LogMADDistributionEstimator<WeibullDistribution> {
    public static final WeibullLogMADEstimator STATIC = new WeibullLogMADEstimator();

    private WeibullLogMADEstimator() {
    }

    @Override
    public WeibullDistribution estimateFromLogMedianMAD(double median, double mad, double shift) {
        double k = 1.0 / (1.3037 * mad);
        double lambda = FastMath.exp(median - MathUtil.LOGLOG2 / k);
        return new WeibullDistribution(k, lambda);
    }

    @Override
    public Class<? super WeibullDistribution> getDistributionClass() {
        return WeibullDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected WeibullLogMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

