/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.StatisticalMoments;
import de.lmu.ifi.dbs.elki.math.statistics.ProbabilityWeightedMoments;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.CauchyMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.EMGOlivierNorbergEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.ExponentialLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.ExponentialMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.ExponentialMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.ExponentialMedianEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GammaLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GammaMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GeneralizedExtremeValueLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GeneralizedLogisticAlternateLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GeneralizedParetoLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GumbelLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GumbelMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.InverseGaussianMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LaplaceLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LaplaceMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogGammaLogMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogLogisticMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogMADDistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogMOMDistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogNormalBilkovaLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogNormalLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogNormalLogMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogNormalLogMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogisticLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogisticMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MADDistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MOMDistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.NormalLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.NormalMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.NormalMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.RayleighLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.RayleighMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.SkewGNormalLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.UniformEnhancedMinMaxEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.UniformLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.UniformMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.UniformMinMaxEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.WeibullLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.WeibullLogMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.tests.KolmogorovSmirnovTest;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.jafama.FastMath;

public class BestFitEstimator
implements DistributionEstimator<Distribution> {
    private static final Logging LOG = Logging.getLogger(BestFitEstimator.class);
    public static final BestFitEstimator STATIC = new BestFitEstimator();
    protected Collection<MOMDistributionEstimator<?>> momests = new ArrayList(5);
    protected Collection<MADDistributionEstimator<?>> madests;
    protected Collection<LMMDistributionEstimator<?>> lmmests;
    protected Collection<LogMOMDistributionEstimator<?>> logmomests;
    protected Collection<LogMADDistributionEstimator<?>> logmadests;

    protected BestFitEstimator() {
        this.momests.add(NormalMOMEstimator.STATIC);
        this.momests.add(GammaMOMEstimator.STATIC);
        this.momests.add(InverseGaussianMOMEstimator.STATIC);
        this.momests.add(ExponentialMOMEstimator.STATIC);
        this.momests.add(EMGOlivierNorbergEstimator.STATIC);
        this.madests = new ArrayList(10);
        this.madests.add(NormalMADEstimator.STATIC);
        this.madests.add(ExponentialMADEstimator.STATIC);
        this.madests.add(ExponentialMedianEstimator.STATIC);
        this.madests.add(LaplaceMADEstimator.STATIC);
        this.madests.add(GumbelMADEstimator.STATIC);
        this.madests.add(CauchyMADEstimator.STATIC);
        this.madests.add(LogisticMADEstimator.STATIC);
        this.madests.add(RayleighMADEstimator.STATIC);
        this.madests.add(UniformMADEstimator.STATIC);
        this.lmmests = new ArrayList(15);
        this.lmmests.add(NormalLMMEstimator.STATIC);
        this.lmmests.add(GammaLMMEstimator.STATIC);
        this.lmmests.add(ExponentialLMMEstimator.STATIC);
        this.lmmests.add(LaplaceLMMEstimator.STATIC);
        this.lmmests.add(GumbelLMMEstimator.STATIC);
        this.lmmests.add(LogisticLMMEstimator.STATIC);
        this.lmmests.add(GeneralizedLogisticAlternateLMMEstimator.STATIC);
        this.lmmests.add(LogNormalLMMEstimator.STATIC);
        this.lmmests.add(LogNormalBilkovaLMMEstimator.STATIC);
        this.lmmests.add(SkewGNormalLMMEstimator.STATIC);
        this.lmmests.add(GeneralizedExtremeValueLMMEstimator.STATIC);
        this.lmmests.add(GeneralizedParetoLMMEstimator.STATIC);
        this.lmmests.add(RayleighLMMEstimator.STATIC);
        this.lmmests.add(WeibullLMMEstimator.STATIC);
        this.lmmests.add(UniformLMMEstimator.STATIC);
        this.logmomests = new ArrayList(2);
        this.logmomests.add(LogNormalLogMOMEstimator.STATIC);
        this.logmomests.add(LogGammaLogMOMEstimator.STATIC);
        this.logmadests = new ArrayList(3);
        this.logmadests.add(LogNormalLogMADEstimator.STATIC);
        this.logmadests.add(LogLogisticMADEstimator.STATIC);
        this.logmadests.add(WeibullLogMADEstimator.STATIC);
    }

    @Override
    public <A> Distribution estimate(A data, NumberArrayAdapter<?, A> adapter) {
        double[] lmm;
        int numlmm = 0;
        for (LMMDistributionEstimator<?> est : this.lmmests) {
            numlmm = Math.max(numlmm, est.getNumMoments());
        }
        int len = adapter.size(data);
        StatisticalMoments mom = new StatisticalMoments();
        StatisticalMoments logmom = new StatisticalMoments();
        double[] x = new double[len];
        double[] scratch = new double[len];
        double[] logx = new double[len];
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Computing statistical moments and L-Moments.");
        }
        for (int i = 0; i < len; ++i) {
            x[i] = adapter.getDouble(data, i);
            double val = x[i];
            if (!(Double.NEGATIVE_INFINITY < val) || !(val < Double.POSITIVE_INFINITY)) continue;
            mom.put(val);
        }
        if (mom.getMax() <= mom.getMin()) {
            LOG.warning("Constant distribution detected. Cannot fit.");
            return new UniformDistribution(mom.getMin() - 1.0, mom.getMax() + 1.0);
        }
        Arrays.sort(x);
        try {
            lmm = numlmm > 0 ? ProbabilityWeightedMoments.samLMR(x, DoubleArrayAdapter.STATIC, numlmm) : null;
        }
        catch (ArithmeticException e) {
            lmm = null;
        }
        double min = x[0];
        double median = 0.5 * (x[len >> 1] + x[len + 1 >> 1]);
        double max = x[len - 1];
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Computing statistical moments in logspace.");
        }
        double shift = Math.min(0.0, min - (max - min) * 1.0E-10);
        for (int i = 0; i < len; ++i) {
            double val = x[i] - shift;
            logx[i] = val = val > 0.0 ? FastMath.log(val) : Double.NEGATIVE_INFINITY;
            if (!(Double.NEGATIVE_INFINITY < val) || !(val < Double.POSITIVE_INFINITY)) continue;
            logmom.put(val);
        }
        double logmedian = 0.5 * (logx[len >> 1] + logx[len + 1 >> 1]);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Computing MADs.");
        }
        double mad = MADDistributionEstimator.computeMAD(x, len, median, scratch);
        double logmad = MADDistributionEstimator.computeMAD(logx, len, logmedian, scratch);
        BestFit best = new BestFit(x, scratch);
        for (MOMDistributionEstimator<?> mOMDistributionEstimator : this.momests) {
            try {
                best.test((DistributionEstimator<?>)mOMDistributionEstimator, (Distribution)mOMDistributionEstimator.estimateFromStatisticalMoments(mom));
            }
            catch (ArithmeticException e) {
                this.warnIfDebugging(e, mOMDistributionEstimator);
            }
        }
        for (MADDistributionEstimator mADDistributionEstimator : this.madests) {
            try {
                best.test(mADDistributionEstimator, (Distribution)mADDistributionEstimator.estimateFromMedianMAD(median, mad));
            }
            catch (ArithmeticException e) {
                this.warnIfDebugging(e, mADDistributionEstimator);
            }
        }
        for (LMMDistributionEstimator lMMDistributionEstimator : this.lmmests) {
            if (lmm == null) continue;
            try {
                best.test(lMMDistributionEstimator, (Distribution)lMMDistributionEstimator.estimateFromLMoments(lmm));
            }
            catch (ArithmeticException e) {
                this.warnIfDebugging(e, lMMDistributionEstimator);
            }
        }
        for (LogMOMDistributionEstimator logMOMDistributionEstimator : this.logmomests) {
            try {
                best.test(logMOMDistributionEstimator, (Distribution)logMOMDistributionEstimator.estimateFromLogStatisticalMoments(logmom, shift));
            }
            catch (ArithmeticException e) {
                this.warnIfDebugging(e, logMOMDistributionEstimator);
            }
        }
        for (LogMADDistributionEstimator logMADDistributionEstimator : this.logmadests) {
            try {
                best.test(logMADDistributionEstimator, (Distribution)logMADDistributionEstimator.estimateFromLogMedianMAD(logmedian, logmad, shift));
            }
            catch (ArithmeticException e) {
                this.warnIfDebugging(e, logMADDistributionEstimator);
            }
        }
        DistributionEstimator<UniformDistribution> est = UniformMinMaxEstimator.STATIC;
        best.test(est, ((UniformMinMaxEstimator)est).estimate(min, max));
        est = UniformEnhancedMinMaxEstimator.STATIC;
        best.test(est, ((UniformEnhancedMinMaxEstimator)est).estimate(min, max, len));
        if (LOG.isVeryVerbose()) {
            LOG.veryverbose("Best distribution fit: " + best.score + " " + best.toString() + " via " + best.est);
        }
        return best.dist;
    }

    private void warnIfDebugging(ArithmeticException e, DistributionEstimator<?> est) {
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Fitting distribution " + est.getClass().getSimpleName() + " failed: " + e.getMessage());
        }
    }

    @Override
    public Class<? super Distribution> getDistributionClass() {
        return Distribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected BestFitEstimator makeInstance() {
            return STATIC;
        }
    }

    private static class BestFit {
        Distribution dist = null;
        double score = Double.POSITIVE_INFINITY;
        DistributionEstimator<?> est = null;
        private double[] x;
        private double[] scratch;

        public BestFit(double[] x, double[] scratch) {
            this.x = x;
            this.scratch = scratch;
        }

        private static double testFit(double[] x, double[] test, Distribution dist) throws ArithmeticException {
            for (int i = 0; i < test.length; ++i) {
                double v = dist.cdf(x[i]);
                if (Double.isNaN(v)) {
                    throw new ArithmeticException("Got NaN after fitting " + dist.toString());
                }
                test[i] = v >= 1.0 ? 1.0 : (v <= 0.0 ? 0.0 : v);
            }
            Arrays.sort(test);
            return KolmogorovSmirnovTest.simpleTest(test);
        }

        public void test(DistributionEstimator<?> est, Distribution d) {
            double score = BestFit.testFit(this.x, this.scratch, d);
            if (LOG.isDebuggingFine()) {
                LOG.debugFine(est.getClass().getSimpleName() + ": " + score + " " + d.toString());
            }
            if (score < this.score) {
                this.dist = d;
                this.score = score;
                this.est = est;
            }
        }
    }
}

