/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class TrimmedEstimator<D extends Distribution>
implements DistributionEstimator<D> {
    private DistributionEstimator<D> inner;
    private double trim;

    public TrimmedEstimator(DistributionEstimator<D> inner, double trim) {
        this.inner = inner;
        this.trim = trim;
    }

    @Override
    public <A> D estimate(A data, NumberArrayAdapter<?, A> adapter) {
        final double[] x = TrimmedEstimator.toPrimitiveDoubleArray(data, adapter);
        final int len = x.length;
        final int num = (int)((double)len * this.trim);
        final int cut1 = num >> 1;
        int cut2 = num - cut1;
        QuickSelect.quickSelect(x, 0, len, cut1);
        QuickSelect.quickSelect(x, cut1, len, len - 1 - cut2);
        return this.inner.estimate(x, new DoubleArrayAdapter(){

            @Override
            public double getDouble(double[] array, int off) throws IndexOutOfBoundsException {
                return x[off + cut1];
            }

            @Override
            public int size(double[] array) {
                return len - num;
            }
        });
    }

    public static <A> double[] toPrimitiveDoubleArray(A data, NumberArrayAdapter<?, A> adapter) {
        if (adapter == DoubleArrayAdapter.STATIC) {
            return (double[])((double[])data).clone();
        }
        int len = adapter.size(data);
        double[] x = new double[len];
        for (int i = 0; i < len; ++i) {
            x[i] = adapter.getDouble(data, i);
        }
        return x;
    }

    @Override
    public Class<? super D> getDistributionClass() {
        return this.inner.getDistributionClass();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.inner.toString() + ", trim=" + this.trim + ")";
    }

    public static class Parameterizer<D extends Distribution>
    extends AbstractParameterizer {
        public static final OptionID INNER_ID = new OptionID("trimmedestimate.inner", "Estimator to use on the trimmed data.");
        public static final OptionID TRIM_ID = new OptionID("trimmedestimate.trim", "Relative amount of data to trim on each end, must be 0 < trim < 0.5");
        private DistributionEstimator<D> inner;
        private double trim;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter trimP;
            super.makeOptions(config);
            ObjectParameter innerP = new ObjectParameter(INNER_ID, DistributionEstimator.class);
            if (config.grab(innerP)) {
                this.inner = (DistributionEstimator)innerP.instantiateClass(config);
            }
            if (config.grab(trimP = (DoubleParameter)((DoubleParameter)new DoubleParameter(TRIM_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_HALF_DOUBLE))) {
                this.trim = trimP.doubleValue();
            }
        }

        @Override
        protected TrimmedEstimator<D> makeInstance() {
            return new TrimmedEstimator<D>(this.inner, this.trim);
        }
    }
}

