/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta.TrimmedEstimator;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;

@Reference(authors="C. Hastings, F. Mosteller, J. W. Tukey, C. P. Winsor", title="Low moments for small samples: a comparative study of order statistics", booktitle="The Annals of Mathematical Statistics, 18(3)", url="https://doi.org/10.1214/aoms/1177730388", bibkey="doi:10.1214/aoms/1177730388")
@Alias(value={"de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta.WinsorisingEstimator"})
public class WinsorizingEstimator<D extends Distribution>
implements DistributionEstimator<D> {
    private DistributionEstimator<D> inner;
    private double winsorize;

    public WinsorizingEstimator(DistributionEstimator<D> inner, double winsorize) {
        this.inner = inner;
        this.winsorize = winsorize;
    }

    @Override
    public <A> D estimate(A data, NumberArrayAdapter<?, A> adapter) {
        double[] x = TrimmedEstimator.toPrimitiveDoubleArray(data, adapter);
        int len = x.length;
        int num = (int)((double)len * this.winsorize);
        int cut1 = num >> 1;
        int cut2 = num - cut1;
        double min = QuickSelect.quickSelect(x, 0, len, cut1);
        double max = QuickSelect.quickSelect(x, cut1, len, len - 1 - cut2);
        Arrays.fill(x, 0, cut1, min);
        Arrays.fill(x, len - cut2, len, max);
        return this.inner.estimate(x, DoubleArrayAdapter.STATIC);
    }

    @Override
    public Class<? super D> getDistributionClass() {
        return this.inner.getDistributionClass();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.inner.toString() + ", winsorize=" + this.winsorize + ")";
    }

    public static class Parameterizer<D extends Distribution>
    extends AbstractParameterizer {
        public static final OptionID INNER_ID = new OptionID("winsorize.inner", "Estimator to use on the winsorized data.");
        public static final OptionID WINSORIZE_ID = new OptionID("winsorize.winsorize", "Relative amount of data to winsorize on each end, must be 0 < winsorize < 0.5");
        private DistributionEstimator<D> inner;
        private double winsorize;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter trimP;
            super.makeOptions(config);
            ObjectParameter innerP = new ObjectParameter(INNER_ID, DistributionEstimator.class);
            if (config.grab(innerP)) {
                this.inner = (DistributionEstimator)innerP.instantiateClass(config);
            }
            if (config.grab(trimP = (DoubleParameter)((DoubleParameter)new DoubleParameter(WINSORIZE_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_HALF_DOUBLE))) {
                this.winsorize = trimP.doubleValue();
            }
        }

        @Override
        protected WinsorizingEstimator<D> makeInstance() {
            return new WinsorizingEstimator<D>(this.inner, this.winsorize);
        }
    }
}

