/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="Oussama Chelly, Michael E. Houle, Ken-ichi Kawarabayashi", title="Enhanced Estimation of Local Intrinsic Dimensionality Using Auxiliary Distances", booktitle="Contributed to ELKI", bibkey="tr/nii/ChellyHK16")
public class ALIDEstimator
implements IntrinsicDimensionalityEstimator {
    public static final ALIDEstimator STATIC = new ALIDEstimator();

    @Override
    public double estimate(KNNQuery<?> knnq, DBIDRef cur, int k) {
        int a = 0;
        double sum = 0.0;
        KNNList kl = knnq.getKNNForDBID(cur, k);
        double w = kl.getKNNDistance();
        double halfw = 0.5 * w;
        DoubleDBIDListIter it = kl.iter();
        while (it.valid()) {
            if (!(it.doubleValue() <= 0.0) && !DBIDUtil.equal(cur, it)) {
                double v = it.doubleValue();
                sum += v < halfw ? FastMath.log(v / w) : FastMath.log1p((v - w) / w);
                ++a;
                double nw = w - v;
                double halfnw = 0.5 * nw;
                DoubleDBIDListIter it2 = knnq.getKNNForDBID(it, k).iter();
                while (it2.valid() && it2.doubleValue() <= nw) {
                    if (!(it2.doubleValue() <= 0.0) && !DBIDUtil.equal(it, it2)) {
                        double v2 = it2.doubleValue();
                        sum += v2 < halfnw ? FastMath.log(v2 / nw) : FastMath.log1p((v2 - nw) / nw);
                        ++a;
                    }
                    it2.advance();
                }
            }
            it.advance();
        }
        return (double)(-a) / sum;
    }

    @Override
    public double estimate(RangeQuery<?> rnq, DBIDRef cur, double range) {
        int a = 0;
        double sum = 0.0;
        double halfw = 0.5 * range;
        DoubleDBIDListIter it = rnq.getRangeForDBID(cur, range).iter();
        while (it.valid()) {
            if (it.doubleValue() != 0.0 && !DBIDUtil.equal(cur, it)) {
                double v = it.doubleValue();
                sum += v < halfw ? FastMath.log(v / range) : FastMath.log1p((v - range) / range);
                ++a;
                double nw = range - v;
                double halfnw = 0.5 * nw;
                DoubleDBIDListIter it2 = rnq.getRangeForDBID(it, nw).iter();
                while (it.valid()) {
                    if (!(it2.doubleValue() <= 0.0) && !DBIDUtil.equal(it, it2)) {
                        double v2 = it2.doubleValue();
                        sum += v2 < halfnw ? FastMath.log(v2 / nw) : FastMath.log1p((v2 - nw) / nw);
                        ++a;
                    }
                    it.advance();
                }
            }
            it.advance();
        }
        return (double)(-a) / sum;
    }

    @Override
    public <A> double estimate(A data, NumberArrayAdapter<?, ? super A> adapter, int size) {
        throw new UnsupportedOperationException("The ALID estimator can only be used with neighbor queries.");
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ALIDEstimator makeInstance() {
            return STATIC;
        }
    }
}

