/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="R. Huisman, K. G. Koedijk, C. J. M. Kool, F. Palm", title="Tail-Index Estimates in Small Samples", booktitle="Journal of Business & Economic Statistics", url="https://doi.org/10.1198/073500101316970421", bibkey="doi:10.1198/073500101316970421")
public class AggregatedHillEstimator
implements IntrinsicDimensionalityEstimator {
    public static final AggregatedHillEstimator STATIC = new AggregatedHillEstimator();

    @Override
    public <A> double estimate(A data, NumberArrayAdapter<?, ? super A> adapter, int end) {
        double v;
        double hsum = 0.0;
        double sum = 0.0;
        int i = 0;
        int valid = 0;
        while (i < end) {
            int n = i++;
            v = adapter.getDouble(data, n);
            if (!(v > 0.0)) continue;
            sum = FastMath.log(v);
            ++valid;
            break;
        }
        while (i < end) {
            v = adapter.getDouble(data, i++);
            assert (v > 0.0);
            double logv = FastMath.log(v);
            hsum += sum / (double)valid++ - logv;
            sum += logv;
        }
        if (valid < 1) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        return (double)(-valid) / hsum;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected AggregatedHillEstimator makeInstance() {
            return STATIC;
        }
    }
}

