/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.Arrays;
import net.jafama.FastMath;

@Reference(authors="M. E. Houle, H. Kashima, M. Nett", title="Generalized expansion dimension", booktitle="12th International Conference on Data Mining Workshops (ICDMW)", url="https://doi.org/10.1109/ICDMW.2012.94", bibkey="DBLP:conf/icdm/HouleKN12")
public class GEDEstimator
implements IntrinsicDimensionalityEstimator {
    public static final GEDEstimator STATIC = new GEDEstimator();
    double[] ilogs = new double[]{0.0};

    @Override
    public <A> double estimate(A data, NumberArrayAdapter<?, ? super A> adapter, int end) {
        int begin = IntrinsicDimensionalityEstimator.countLeadingZeros(data, adapter, end);
        if (end - begin < 2) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        int last = end - begin - 1;
        double[] meds = new double[last];
        if (last >= this.ilogs.length) {
            this.precomputeLogs(last + 1);
        }
        for (int k = 0; k < last; ++k) {
            double logdk = FastMath.log(adapter.getDouble(data, begin + k));
            double log1pk = this.ilogs[k];
            int p = k;
            for (int i = k + 1; i <= last; ++i) {
                double logdi = FastMath.log(adapter.getDouble(data, begin + i));
                if (logdk == logdi) continue;
                meds[p++] = (log1pk - this.ilogs[i]) / (logdk - logdi);
            }
            meds[k] = QuickSelect.median(meds, k, p);
        }
        return QuickSelect.median(meds, 0, last);
    }

    private synchronized void precomputeLogs(int len) {
        if (len <= this.ilogs.length) {
            return;
        }
        double[] logs = Arrays.copyOf(this.ilogs, len);
        for (int i = this.ilogs.length; i < len; ++i) {
            logs[i] = FastMath.log1p(i);
        }
        this.ilogs = logs;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GEDEstimator makeInstance() {
            return STATIC;
        }
    }
}

