/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="B. M. Hill", title="A simple general approach to inference about the tail of a distribution", booktitle="The annals of statistics 3(5)", url="https://doi.org/10.1214/aos/1176343247", bibkey="doi:10.1214/aos/1176343247")
public class HillEstimator
implements IntrinsicDimensionalityEstimator {
    public static final HillEstimator STATIC = new HillEstimator();

    @Override
    public <A> double estimate(A data, NumberArrayAdapter<?, ? super A> adapter, int end) {
        int last = end - 1;
        double w = adapter.getDouble(data, last);
        if (w <= 0.0) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        double halfw = 0.5 * w;
        double sum = 0.0;
        int valid = 0;
        for (int i = 0; i < last; ++i) {
            double v = adapter.getDouble(data, i);
            if (!(v > 0.0)) continue;
            sum += v < halfw ? FastMath.log(v / w) : FastMath.log1p((v - w) / w);
            ++valid;
        }
        if (valid < 1) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        return (double)(-valid) / sum;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HillEstimator makeInstance() {
            return STATIC;
        }
    }
}

