/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;

public interface IntrinsicDimensionalityEstimator {
    public <A> double estimate(A var1, NumberArrayAdapter<?, ? super A> var2, int var3);

    default public double estimate(double[] distances) {
        return this.estimate(distances, DoubleArrayAdapter.STATIC, distances.length);
    }

    default public double estimate(double[] distances, int size) {
        return this.estimate(distances, DoubleArrayAdapter.STATIC, size);
    }

    default public <A> double estimate(A data, NumberArrayAdapter<?, ? super A> adapter) {
        return this.estimate(data, adapter, adapter.size(data));
    }

    default public double estimate(KNNQuery<?> knnq, DBIDRef cur, int k) {
        double[] buf = new double[k];
        int p = 0;
        DoubleDBIDListIter it = knnq.getKNNForDBID(cur, k).iter();
        while (it.valid() && p < k) {
            if (it.doubleValue() != 0.0 && !DBIDUtil.equal(cur, it)) {
                buf[p++] = it.doubleValue();
            }
            it.advance();
        }
        if (p < 1) {
            throw new ArithmeticException("ID estimation requires non-zero distances.");
        }
        return this.estimate(buf, DoubleArrayAdapter.STATIC, p);
    }

    default public double estimate(RangeQuery<?> rnq, DBIDRef cur, double range) {
        DoubleArray buf = new DoubleArray();
        int p = 0;
        DoubleDBIDListIter it = rnq.getRangeForDBID(cur, range).iter();
        while (it.valid()) {
            if (it.doubleValue() != 0.0 && !DBIDUtil.equal(cur, it)) {
                buf.add(it.doubleValue());
                ++p;
            }
            it.advance();
        }
        if (p < 1) {
            throw new ArithmeticException("ID estimation requires non-zero distances.");
        }
        return this.estimate(buf, buf, p);
    }

    public static <A> int countLeadingZeros(A data, NumberArrayAdapter<?, ? super A> adapter, int end) {
        for (int begin = 0; begin < end; ++begin) {
            if (!(adapter.getDouble(data, begin) > 0.0)) continue;
            return begin;
        }
        return end;
    }
}

