/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.ProbabilityWeightedMoments;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@References(value={@Reference(authors="L. Amsaleg, O. Chelly, T. Furon, S. Girard, M. E. Houle, K. Kawarabayashi, M. Nett", title="Estimating Local Intrinsic Dimensionality", booktitle="Proc. SIGKDD International Conference on Knowledge Discovery and Data Mining 2015", url="https://doi.org/10.1145/2783258.2783405", bibkey="DBLP:conf/kdd/AmsalegCFGHKN15"), @Reference(authors="J. R. M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report", bibkey="tr/ibm/Hosking00")})
public class LMomentsEstimator
implements IntrinsicDimensionalityEstimator {
    public static final LMomentsEstimator STATIC = new LMomentsEstimator();

    @Override
    public <A> double estimate(A data, NumberArrayAdapter<?, ? super A> adapter, int end) {
        int begin = IntrinsicDimensionalityEstimator.countLeadingZeros(data, adapter, end);
        int len = end - begin;
        if (len < 2) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        if (len == 2) {
            double v1 = adapter.getDouble(data, begin) / adapter.getDouble(data, begin + 1);
            return v1 / (1.0 - v1);
        }
        double w = adapter.getDouble(data, end - 1);
        double[] lmom = ProbabilityWeightedMoments.samLMR(data, new ReverseAdapter<A>(adapter, begin, end), 2);
        if (lmom[1] == 0.0) {
            return -0.5 * (lmom[0] * 2.0) / w * ((double)len + 0.5) * (double)len;
        }
        return -0.5 * (lmom[0] * lmom[0] / lmom[1] - lmom[0]) / w;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LMomentsEstimator makeInstance() {
            return STATIC;
        }
    }

    private static class ReverseAdapter<A>
    implements NumberArrayAdapter<Double, A> {
        private int size;
        private int last;
        private NumberArrayAdapter<?, ? super A> inner;

        public ReverseAdapter(NumberArrayAdapter<?, ? super A> inner, int begin, int end) {
            this.inner = inner;
            this.size = end - begin;
            this.last = end - 1;
        }

        @Override
        public int size(A array) {
            return this.size;
        }

        @Override
        public Double get(A array, int off) throws IndexOutOfBoundsException {
            return this.inner.getDouble(array, this.last - off);
        }

        @Override
        public double getDouble(A array, int off) throws IndexOutOfBoundsException {
            return this.inner.getDouble(array, this.last - off);
        }

        @Override
        public float getFloat(A array, int off) throws IndexOutOfBoundsException {
            return this.inner.getFloat(array, this.last - off);
        }

        @Override
        public int getInteger(A array, int off) throws IndexOutOfBoundsException {
            return this.inner.getInteger(array, this.last - off);
        }

        @Override
        public short getShort(A array, int off) throws IndexOutOfBoundsException {
            return this.inner.getShort(array, this.last - off);
        }

        @Override
        public long getLong(A array, int off) throws IndexOutOfBoundsException {
            return this.inner.getLong(array, this.last - off);
        }

        @Override
        public byte getByte(A array, int off) throws IndexOutOfBoundsException {
            return this.inner.getByte(array, this.last - off);
        }
    }
}

