/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="L. Amsaleg, O. Chelly, T. Furon, S. Girard, M. E. Houle, K. Kawarabayashi, M. Nett", title="Estimating Local Intrinsic Dimensionality", booktitle="Proc. SIGKDD International Conference on Knowledge Discovery and Data Mining 2015", url="https://doi.org/10.1145/2783258.2783405", bibkey="DBLP:conf/kdd/AmsalegCFGHKN15")
public class MOMEstimator
implements IntrinsicDimensionalityEstimator {
    public static final MOMEstimator STATIC = new MOMEstimator();

    @Override
    public <A> double estimate(A data, NumberArrayAdapter<?, ? super A> adapter, int end) {
        int last = end - 1;
        double v1 = 0.0;
        int valid = 0;
        for (int i = 0; i < last; ++i) {
            double v = adapter.getDouble(data, i);
            if (!(v > 0.0)) continue;
            v1 += v;
            ++valid;
        }
        if (valid <= 1) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        return (v1 /= (double)valid * adapter.getDouble(data, last)) / (1.0 - v1);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

