/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@References(value={@Reference(authors="L. Amsaleg, O. Chelly, T. Furon, S. Girard, M. E. Houle, K. Kawarabayashi, M. Nett", title="Estimating Local Intrinsic Dimensionality", booktitle="Proc. SIGKDD International Conference on Knowledge Discovery and Data Mining 2015", url="https://doi.org/10.1145/2783258.2783405", bibkey="DBLP:conf/kdd/AmsalegCFGHKN15"), @Reference(authors="J. Maciunas Landwehr, N. C. Matalas, J. R. Wallis", title="Probability weighted moments compared with some traditional techniques in estimating Gumbel parameters and quantiles", booktitle="Water Resources Research 15(5)", url="https://doi.org/10.1029/WR015i005p01055", bibkey="doi:10.1029/WR015i005p01055")})
public class PWM2Estimator
implements IntrinsicDimensionalityEstimator {
    public static final PWM2Estimator STATIC = new PWM2Estimator();

    @Override
    public <A> double estimate(A data, NumberArrayAdapter<?, ? super A> adapter, int end) {
        int begin = IntrinsicDimensionalityEstimator.countLeadingZeros(data, adapter, end);
        if (end - begin <= 3) {
            if (end - begin == 2) {
                double v1 = adapter.getDouble(data, begin) / adapter.getDouble(data, begin + 1);
                return v1 / (1.0 - v1);
            }
            if (end - begin == 3) {
                double v1 = adapter.getDouble(data, begin + 1) * 0.5 / adapter.getDouble(data, begin + 2);
                return v1 / (1.0 - 2.0 * v1);
            }
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        int last = end - 1;
        double v2 = 0.0;
        int valid = 0;
        int j = begin;
        while (j < last) {
            v2 += adapter.getDouble(data, j) * (double)(valid + 2) * (double)(valid + 1);
            ++j;
            ++valid;
        }
        double w = adapter.getDouble(data, last);
        return (v2 /= (double)(valid + 2) * w * (double)(valid + 1) * (double)valid) / (1.0 - 3.0 * v2);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected PWM2Estimator makeInstance() {
            return STATIC;
        }
    }
}

