/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="L. Amsaleg, O. Chelly, T. Furon, S. Girard, M. E. Houle, K. Kawarabayashi, M. Nett", title="Estimating Local Intrinsic Dimensionality", booktitle="Proc. SIGKDD International Conference on Knowledge Discovery and Data Mining 2015", url="https://doi.org/10.1145/2783258.2783405", bibkey="DBLP:conf/kdd/AmsalegCFGHKN15")
public class RVEstimator
implements IntrinsicDimensionalityEstimator {
    public static final RVEstimator STATIC = new RVEstimator();

    @Override
    public <A> double estimate(A data, NumberArrayAdapter<?, ? super A> adapter, int end) {
        int begin = IntrinsicDimensionalityEstimator.countLeadingZeros(data, adapter, end);
        int k = end - begin;
        if (k < 2) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        int n1 = k >> 1;
        int n2 = 3 * k >> 2;
        int n3 = k;
        double r1 = adapter.getDouble(data, begin + n1 - 1);
        double r2 = adapter.getDouble(data, begin + n2 - 1);
        double r3 = adapter.getDouble(data, begin + n3 - 1);
        double p = (r3 - r2) / (r1 - 2.0 * r2 + r3);
        double a2 = (1.0 - p) / p;
        return (FastMath.log((double)n3 / (double)n2) + a2 * FastMath.log((double)n1 / (double)n2)) / (FastMath.log(r3 / r2) + a2 * FastMath.log(r1 / r2));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RVEstimator makeInstance() {
            return STATIC;
        }
    }
}

