/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@References(value={@Reference(authors="M. Kratz, S. I. Resnick", title="The QQ-estimator and heavy tails", booktitle="Communications in Statistics. Stochastic Models 12(4)", url="https://doi.org/10.1080/15326349608807407", bibkey="doi:10.1080/15326349608807407"), @Reference(authors="J. Schultze, J. Steinebach", title="On Least Squares Estimates of an Exponential Tail Coefficient", booktitle="Statistics & Risk Modeling 14(4)", url="https://doi.org/10.1524/strm.1996.14.4.353", bibkey="doi:10.1524/strm.1996.14.4.353"), @Reference(authors="J. Beirlant, G. Dierckx, A. Guillou", title="Estimation of the extreme-value index and generalized quantile plots", booktitle="Bernoulli 11(6)", url="https://doi.org/10.3150/bj/1137421635", bibkey="doi:10.3150/bj/1137421635")})
public class ZipfEstimator
implements IntrinsicDimensionalityEstimator {
    public static final ZipfEstimator STATIC = new ZipfEstimator();

    @Override
    public <A> double estimate(A data, NumberArrayAdapter<?, ? super A> adapter, int end) {
        int begin = IntrinsicDimensionalityEstimator.countLeadingZeros(data, adapter, end);
        int len = end - begin;
        if (len < 2) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        double bias = 0.6;
        double nplus1 = (double)len + 0.6;
        double wls = 0.0;
        double ws = 0.0;
        double ls = 0.0;
        double wws = 0.0;
        for (int i = begin; i < end; ++i) {
            double v = adapter.getDouble(data, i);
            assert (v > 0.0);
            double logv = FastMath.log(v);
            double weight = FastMath.log(nplus1 / ((double)(i - begin) + 0.6));
            wls += weight * logv;
            ws += weight;
            ls += logv;
            wws += weight * weight;
        }
        return -1.0 / (((double)len * wls - ws * ls) / ((double)len * wws - ws * ws));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ZipfEstimator makeInstance() {
            return STATIC;
        }
    }
}

