/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions;

import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"biweight", "quartic"})
public final class BiweightKernelDensityFunction
implements KernelDensityFunction {
    public static final BiweightKernelDensityFunction KERNEL = new BiweightKernelDensityFunction();
    @Reference(authors="J. S. Marron, D. Nolan", title="Canonical kernels for density estimation", booktitle="Statistics & Probability Letters, Volume 7, Issue 3", url="https://doi.org/10.1016/0167-7152(88)90050-8", bibkey="doi:10.1016/0167-71528890050-8")
    public static final double CANONICAL_BANDWIDTH = Math.pow(35.0, 0.2);
    public static final double STDDEV = 1.0 / Math.sqrt(7.0);
    public static final double R = 0.7142857142857143;

    private BiweightKernelDensityFunction() {
    }

    @Override
    public double density(double delta) {
        if (delta >= 1.0) {
            return 0.0;
        }
        double u = 1.0 - delta * delta;
        return 0.9375 * u * u;
    }

    @Override
    public double canonicalBandwidth() {
        return CANONICAL_BANDWIDTH;
    }

    @Override
    public double standardDeviation() {
        return STDDEV;
    }

    @Override
    public double getR() {
        return 0.7142857142857143;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected BiweightKernelDensityFunction makeInstance() {
            return KERNEL;
        }
    }
}

