/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions;

import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"epanechnikov"})
public final class EpanechnikovKernelDensityFunction
implements KernelDensityFunction {
    public static final EpanechnikovKernelDensityFunction KERNEL = new EpanechnikovKernelDensityFunction();
    @Reference(authors="J. S. Marron, D. Nolan", title="Canonical kernels for density estimation", booktitle="Statistics & Probability Letters, Volume 7, Issue 3", url="https://doi.org/10.1016/0167-7152(88)90050-8", bibkey="doi:10.1016/0167-71528890050-8")
    public static final double CANONICAL_BANDWIDTH = Math.pow(15.0, 0.2);
    public static final double STDDEV = 1.0 / Math.sqrt(5.0);
    public static final double R = 0.6;

    private EpanechnikovKernelDensityFunction() {
    }

    @Override
    public double density(double delta) {
        return delta < 1.0 ? 0.75 * (1.0 - delta * delta) : 0.0;
    }

    @Override
    public double canonicalBandwidth() {
        return CANONICAL_BANDWIDTH;
    }

    @Override
    public double standardDeviation() {
        return STDDEV;
    }

    @Override
    public double getR() {
        return 0.6;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected EpanechnikovKernelDensityFunction makeInstance() {
            return KERNEL;
        }
    }
}

