/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

public final class GaussianKernelDensityFunction
implements KernelDensityFunction {
    public static final GaussianKernelDensityFunction KERNEL = new GaussianKernelDensityFunction();
    @Reference(authors="J. S. Marron, D. Nolan", title="Canonical kernels for density estimation", booktitle="Statistics & Probability Letters, Volume 7, Issue 3", url="https://doi.org/10.1016/0167-7152(88)90050-8", bibkey="doi:10.1016/0167-71528890050-8")
    public static final double CANONICAL_BANDWIDTH = FastMath.pow(0.07957747154594767, 0.1);
    public static final double R = 0.5 * MathUtil.ONE_BY_SQRTPI;

    private GaussianKernelDensityFunction() {
    }

    @Override
    public double density(double delta) {
        return MathUtil.ONE_BY_SQRTTWOPI * FastMath.exp(-0.5 * delta * delta);
    }

    @Override
    public double canonicalBandwidth() {
        return CANONICAL_BANDWIDTH;
    }

    @Override
    public double standardDeviation() {
        return 1.0;
    }

    @Override
    public double getR() {
        return R;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GaussianKernelDensityFunction makeInstance() {
            return KERNEL;
        }
    }
}

