/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions;

import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public final class TricubeKernelDensityFunction
implements KernelDensityFunction {
    public static final TricubeKernelDensityFunction KERNEL = new TricubeKernelDensityFunction();
    public static final double CANONICAL_BANDWIDTH = Math.pow(34.0, 0.2);
    private static final double STDDEV = Math.sqrt(0.1440329218106996);
    private static final double R = 0.708502024291498;
    private final double SCALE = 0.8641975308641975;

    private TricubeKernelDensityFunction() {
    }

    @Override
    public double density(double delta) {
        if (delta >= 1.0) {
            return 0.0;
        }
        double u = 1.0 - delta * delta * delta;
        return 0.8641975308641975 * u * u * u;
    }

    @Override
    public double canonicalBandwidth() {
        return CANONICAL_BANDWIDTH;
    }

    @Override
    public double standardDeviation() {
        return STDDEV;
    }

    @Override
    public double getR() {
        return 0.708502024291498;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected TricubeKernelDensityFunction makeInstance() {
            return KERNEL;
        }
    }
}

