/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions;

import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"triweight"})
public final class TriweightKernelDensityFunction
implements KernelDensityFunction {
    public static final TriweightKernelDensityFunction KERNEL = new TriweightKernelDensityFunction();
    @Reference(authors="J. S. Marron, D. Nolan", title="Canonical kernels for density estimation", booktitle="Statistics & Probability Letters, Volume 7, Issue 3", url="https://doi.org/10.1016/0167-7152(88)90050-8", bibkey="doi:10.1016/0167-71528890050-8")
    public static final double CANONICAL_BANDWIDTH = Math.pow(66.08391608391608, 0.2);
    private static final double STDDEV = 0.3333333333333333;
    private static final double R = 0.8158508158508159;

    private TriweightKernelDensityFunction() {
    }

    @Override
    public double density(double delta) {
        if (delta >= 1.0) {
            return 0.0;
        }
        double u = 1.0 - delta * delta;
        return 1.09375 * u * u * u;
    }

    @Override
    public double canonicalBandwidth() {
        return CANONICAL_BANDWIDTH;
    }

    @Override
    public double standardDeviation() {
        return 0.3333333333333333;
    }

    @Override
    public double getR() {
        return 0.8158508158508159;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected TriweightKernelDensityFunction makeInstance() {
            return KERNEL;
        }
    }
}

