/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.tests;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import net.jafama.FastMath;

@Reference(authors="T. W. Anderson, D. A. Darling", title="Asymptotic theory of certain 'goodness of fit' criteria based on stochastic processes", booktitle="Annals of mathematical statistics 23(2)", url="https://doi.org/10.1214/aoms/1177729437", bibkey="doi:10.1214/aoms/1177729437")
public class AndersonDarlingTest {
    private AndersonDarlingTest() {
    }

    public static double A2StandardNormal(double[] sorted) {
        double x;
        int l = sorted.length;
        assert (l > 0);
        double A2 = 0.0;
        int i = 0;
        int j = l - 1;
        int i2 = 1;
        int j2 = (j << 1) + 1;
        while (i < j) {
            x = NormalDistribution.standardNormalCDF(sorted[i]);
            double y = NormalDistribution.standardNormalCDF(sorted[j]);
            double diff1 = FastMath.log(x) + FastMath.log(1.0 - y);
            double diff2 = FastMath.log(1.0 - x) + FastMath.log(y);
            A2 += (double)i2 * diff1 + (double)j2 * diff2;
            ++i;
            --j;
            i2 += 2;
            j2 -= 2;
        }
        if (i == j) {
            x = NormalDistribution.standardNormalCDF(sorted[i]);
            A2 += (double)i2 * (FastMath.log(x) + FastMath.log(1.0 - x));
        }
        A2 /= (double)l;
        return -(A2 += (double)l);
    }

    public static double A2Noncentral(double[] sorted) {
        double x;
        int l = sorted.length;
        assert (l > 1);
        double m = 0.0;
        for (int i = 0; i < l; ++i) {
            m += sorted[i];
        }
        m /= (double)l;
        double var = 0.0;
        for (int i = 0; i < l; ++i) {
            double d = sorted[i] - m;
            var += d * d;
        }
        double isigma = (var /= (double)(l - 1)) > 0.0 ? Math.sqrt(1.0 / var) : 1.0;
        double A2 = 0.0;
        int i = 0;
        int j = l - 1;
        int i2 = 1;
        int j2 = (j << 1) + 1;
        while (i < j) {
            x = NormalDistribution.standardNormalCDF((sorted[i] - m) * isigma);
            double y = NormalDistribution.standardNormalCDF((sorted[j] - m) * isigma);
            double diff1 = FastMath.log(x) + FastMath.log(1.0 - y);
            double diff2 = FastMath.log(1.0 - x) + FastMath.log(y);
            A2 += (double)i2 * diff1 + (double)j2 * diff2;
            ++i;
            --j;
            i2 += 2;
            j2 -= 2;
        }
        if (i == j) {
            x = NormalDistribution.standardNormalCDF((sorted[i] - m) * isigma);
            A2 += (double)i2 * (FastMath.log(x) + FastMath.log(1.0 - x));
        }
        A2 /= (double)l;
        return -(A2 += (double)l);
    }

    @Reference(authors="M. A. Stephens", title="EDF Statistics for Goodness of Fit and Some Comparisons", booktitle="Journal of the American Statistical Association, Volume 69, Issue 347", url="https://doi.org/10.1080/01621459.1974.10480196", bibkey="doi:10.1080/01621459.1974.10480196")
    public static double removeBiasNormalDistribution(double A2, int n) {
        return A2 * (1.0 + 4.0 / (double)n - 25.0 / (double)(n * n));
    }
}

