/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.tests;

import de.lmu.ifi.dbs.elki.math.statistics.tests.GoodnessOfFitTest;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.Arrays;

public class KolmogorovSmirnovTest
implements GoodnessOfFitTest {
    public static KolmogorovSmirnovTest STATIC = new KolmogorovSmirnovTest();

    @Override
    public double deviation(double[] fullSample, double[] conditionalSample) {
        Arrays.sort(fullSample);
        Arrays.sort(conditionalSample);
        return KolmogorovSmirnovTest.calculateTestStatistic(fullSample, conditionalSample);
    }

    public static double calculateTestStatistic(double[] sample1, double[] sample2) {
        double maximum = 0.0;
        int index1 = 0;
        int index2 = 0;
        double cdf1 = 0.0;
        double cdf2 = 0.0;
        while (index1 < sample1.length && index2 < sample2.length) {
            double x1 = sample1[index1];
            double x2 = sample2[index2];
            if (x1 <= x2) {
                ++index1;
                while (index1 < sample1.length && sample1[index1] == x1) {
                    ++index1;
                }
                cdf1 = ((double)index1 + 1.0) / ((double)sample1.length + 1.0);
            }
            if (x1 >= x2) {
                ++index2;
                while (index2 < sample2.length && sample2[index2] == x2) {
                    ++index2;
                }
                cdf2 = ((double)index2 + 1.0) / ((double)sample2.length + 1.0);
            }
            maximum = Math.max(maximum, Math.abs(cdf1 - cdf2));
        }
        return maximum;
    }

    public static double simpleTest(double[] test) {
        double scale = 1.0 / ((double)test.length + 1.0);
        double maxdev = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < test.length; ++i) {
            double expected = ((double)i + 1.0) * scale;
            double dev = Math.abs(test[i] - expected);
            if (!(dev > maxdev)) continue;
            maxdev = dev;
        }
        return Math.abs(maxdev);
    }

    public static double simpleTest(double[] test, double min, double max) {
        double scale = (max - min) / ((double)test.length + 1.0);
        double maxdev = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < test.length; ++i) {
            double expected = ((double)i + 1.0) * scale + min;
            double dev = Math.abs(test[i] - expected);
            if (!(dev > maxdev)) continue;
            maxdev = dev;
        }
        return Math.abs(maxdev);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected KolmogorovSmirnovTest makeInstance() {
            return STATIC;
        }
    }
}

