/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.tests;

import de.lmu.ifi.dbs.elki.math.statistics.tests.GoodnessOfFitTest;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import java.util.Arrays;

@References(value={@Reference(authors="F. W. Scholz, M. A. Stephens", title="K-sample Anderson\u2013Darling tests", booktitle="Journal of the American Statistical Association, 82(399)", url="https://doi.org/10.1080/01621459.1987.10478517", bibkey="doi:10.1080/01621459.1987.10478517"), @Reference(authors="D. A. Darling", title="The Kolmogorov-Smirnov, Cramer-von Mises tests", booktitle="Annals of mathematical statistics 28(4)", url="https://doi.org/10.1214/aoms/1177706788", bibkey="doi:10.1214/aoms/1177706788"), @Reference(authors="A. N. Pettitt", title="A two-sample Anderson-Darling rank statistic", booktitle="Biometrika 63 (1)", url="https://doi.org/10.1093/biomet/63.1.161", bibkey="doi:10.1093/biomet/63.1.161")})
public class StandardizedTwoSampleAndersonDarlingTest
implements GoodnessOfFitTest {
    public static final StandardizedTwoSampleAndersonDarlingTest STATIC = new StandardizedTwoSampleAndersonDarlingTest();

    @Override
    public double deviation(double[] sample1, double[] sample2) {
        double A2 = this.unstandardized(sample1, sample2);
        int N = sample1.length + sample2.length;
        double H = 1.0 / (double)sample1.length + 1.0 / (double)sample2.length;
        double g = 0.0;
        double h = 1.0 / (double)(N - 1);
        for (int i = N - 2; i > 0; --i) {
            g += h / (double)(N - i);
            h += 1.0 / (double)i;
        }
        double a = 4.0 * g - 6.0 + (10.0 - 6.0 * g) * H;
        double b = 12.0 * g - 22.0 + 8.0 * h + (2.0 * g - 14.0 * h - 4.0) * H;
        double c = 36.0 * h + 4.0 + (2.0 * h - 6.0) * H;
        double d = 24.0;
        double N2 = N * N;
        double N3 = N2 * (double)N;
        double sigmasq = (a * N3 + b * N2 + c * (double)N + 24.0) / (((double)N - 1.0) * ((double)N - 2.0) * ((double)N - 3.0));
        return sigmasq > 0.0 ? (A2 - 1.0) / Math.sqrt(sigmasq) : 0.0;
    }

    public double deviation(double[][] samples) {
        int N = this.totalLength(samples);
        double A2 = this.unstandardized(samples, N);
        int k = samples.length;
        double H = 0.0;
        for (double[] sample : samples) {
            H += 1.0 / (double)sample.length;
        }
        double g = 0.0;
        double h = 1.0 / (double)(N - 1);
        for (int i = N - 2; i > 0; --i) {
            g += h / (double)(N - i);
            h += 1.0 / (double)i;
        }
        double a = (4.0 * g - 6.0) * (double)(k - 1) + (10.0 - 6.0 * g) * H;
        double N2 = N * N;
        double N3 = N2 * (double)N;
        int k2 = k * k;
        double hk = h * (double)k;
        double b = (2.0 * g - 4.0) * (double)k2 + 8.0 * hk + (2.0 * g - 14.0 * h - 4.0) * H - 8.0 * h + 4.0 * g - 6.0;
        double c = (6.0 * h + 2.0 * g - 2.0) * (double)k2 + (4.0 * h - 4.0 * g + 6.0) * (double)k + (2.0 * h - 6.0) * H + 4.0 * h;
        double d = (2.0 * h + 6.0) * (double)k2 - 4.0 * hk;
        double sigmasq = (a * N3 + b * N2 + c * (double)N + d) / (((double)N - 1.0) * ((double)N - 2.0) * ((double)N - 3.0));
        return sigmasq > 0.0 ? (A2 - (double)(k - 1)) / Math.sqrt(sigmasq) : 0.0;
    }

    public double unstandardized(double[][] samples) {
        int N = this.totalLength(samples);
        return this.unstandardized(samples, N);
    }

    private double unstandardized(double[][] samples, int N) {
        int k = samples.length;
        double[] combined = new double[N];
        int p = 0;
        for (double[] samp : samples) {
            Arrays.sort(samp);
            System.arraycopy(samp, 0, combined, p, samp.length);
            p += samp.length;
        }
        assert (p == N);
        Arrays.sort(combined);
        int[] m = new int[k];
        double[] Ak = new double[k];
        int j = 0;
        while (j < N) {
            double x = combined[j++];
            int lj = 1;
            while (j < N && combined[j] == x) {
                ++j;
                ++lj;
            }
            int i = 0;
            while (i < k) {
                double[] sam = samples[i];
                int mi = m[i];
                assert (mi >= sam.length || sam[mi] >= x);
                int fi = 0;
                while (mi < sam.length && sam[mi] == x) {
                    ++mi;
                    ++fi;
                }
                if (fi > 0) {
                    assert (m[i] + fi == mi);
                    m[i] = mi;
                }
                double bi = (double)j - 0.5 * (double)lj;
                double v = (double)N * ((double)mi - 0.5 * (double)fi) - (double)sam.length * bi;
                int n = i++;
                Ak[n] = Ak[n] + (double)lj * v * v / (bi * ((double)N - bi) - 0.25 * (double)N * (double)lj);
            }
        }
        double A2 = 0.0;
        for (int j2 = 0; j2 < k; ++j2) {
            A2 += Ak[j2] / (double)samples[j2].length;
        }
        return A2 *= ((double)N - 1.0) / (double)(N * N);
    }

    public double unstandardized(double[] sample1, double[] sample2) {
        int n1 = sample1.length;
        int n2 = sample2.length;
        int N = n1 + n2;
        double[] combined = new double[N];
        Arrays.sort(sample1);
        System.arraycopy(sample1, 0, combined, 0, n1);
        Arrays.sort(sample2);
        System.arraycopy(sample2, 0, combined, n1, n2);
        Arrays.sort(combined);
        int m1 = 0;
        int m2 = 0;
        double Ak1 = 0.0;
        double Ak2 = 0.0;
        int j = 0;
        while (j < N) {
            double x = combined[j++];
            int lj = 1;
            while (j < N && combined[j] == x) {
                ++j;
                ++lj;
            }
            double bi = (double)j - 0.5 * (double)lj;
            assert (m1 >= n1 || sample1[m1] >= x);
            int f1 = 0;
            while (m1 < n1 && sample1[m1] == x) {
                ++m1;
                ++f1;
            }
            double v = (double)N * ((double)m1 - 0.5 * (double)f1) - (double)n1 * bi;
            Ak1 += (double)lj * v * v / (bi * ((double)N - bi) - 0.25 * (double)N * (double)lj);
            assert (m2 >= n2 || sample2[m2] >= x);
            int f2 = 0;
            while (m2 < n2 && sample2[m2] == x) {
                ++m2;
                ++f2;
            }
            v = (double)N * ((double)m2 - 0.5 * (double)f2) - (double)n2 * bi;
            Ak2 += (double)lj * v * v / (bi * ((double)N - bi) - 0.25 * (double)N * (double)lj);
        }
        double A2 = Ak1 / (double)n1 + Ak2 / (double)n2;
        return A2 *= ((double)N - 1.0) / (double)(N * N);
    }

    private int totalLength(double[][] samples) {
        int N = 0;
        for (double[] samp : samples) {
            N += samp.length;
        }
        return N;
    }
}

