/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.tests;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.StudentsTDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.tests.GoodnessOfFitTest;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class WelchTTest
implements GoodnessOfFitTest {
    public static final WelchTTest STATIC = new WelchTTest();

    @Override
    public double deviation(double[] sample1, double[] sample2) {
        MeanVariance mv1 = new MeanVariance();
        MeanVariance mv2 = new MeanVariance();
        for (double d : sample1) {
            mv1.put(d);
        }
        for (double d : sample2) {
            mv2.put(d);
        }
        double t = WelchTTest.calculateTestStatistic(mv1, mv2);
        int v = WelchTTest.calculateDOF(mv1, mv2);
        return 1.0 - WelchTTest.calculatePValue(t, v);
    }

    public static double calculateTestStatistic(MeanVariance mv1, MeanVariance mv2) {
        double delta = mv1.getMean() - mv2.getMean();
        double relvar1 = mv1.getSampleVariance() / mv1.getCount();
        double relvar2 = mv2.getSampleVariance() / mv2.getCount();
        return delta / Math.sqrt(relvar1 + relvar2);
    }

    public static int calculateDOF(MeanVariance mv1, MeanVariance mv2) {
        double relvar1 = mv1.getSampleVariance() / mv1.getCount();
        double relvar2 = mv2.getSampleVariance() / mv2.getCount();
        double wvariance = relvar1 + relvar2;
        double div = relvar1 * relvar1 / (mv1.getCount() - 1.0) + relvar2 * relvar2 / (mv2.getCount() - 1.0);
        return (int)(wvariance * wvariance / div);
    }

    public static double calculatePValue(double t, int v) {
        return 2.0 * (1.0 - StudentsTDistribution.cdf(Math.abs(t), v));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected WelchTTest makeInstance() {
            return STATIC;
        }
    }
}

