/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.parallel;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ParallelCore {
    public static final int ALL_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private static final ParallelCore STATIC = new ParallelCore(ALL_PROCESSORS);
    private volatile ThreadPoolExecutor executor;
    private volatile int connected;
    private int processors;

    protected ParallelCore(int processors) {
        this.processors = processors;
    }

    public static ParallelCore getCore() {
        return STATIC;
    }

    public int getParallelism() {
        return this.executor != null ? this.executor.getMaximumPoolSize() : this.processors;
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    public synchronized void connect() {
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(0, this.processors, 10L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.executor.allowCoreThreadTimeOut(true);
        }
        if (++this.connected == 1) {
            this.executor.allowCoreThreadTimeOut(false);
            this.executor.setCorePoolSize(this.executor.getMaximumPoolSize());
        }
    }

    public synchronized void disconnect() {
        if (--this.connected == 0) {
            this.executor.allowCoreThreadTimeOut(true);
            this.executor.setCorePoolSize(0);
        }
    }
}

