/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.parallel;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.ParallelCore;
import de.lmu.ifi.dbs.elki.parallel.processor.Processor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class ParallelExecutor {
    private ParallelExecutor() {
    }

    public static void run(DBIDs ids, Processor ... procs) {
        ParallelCore core = ParallelCore.getCore();
        core.connect();
        try {
            ArrayDBIDs aids = DBIDUtil.ensureArray(ids);
            int size = aids.size();
            int numparts = core.getParallelism();
            numparts = size > numparts * numparts * 16 ? numparts * Math.max(1, numparts - 1) : numparts;
            int blocksize = (size + (numparts - 1)) / numparts;
            ArrayList<Future<ArrayDBIDs>> parts = new ArrayList<Future<ArrayDBIDs>>(numparts);
            for (int i = 0; i < numparts; ++i) {
                int n = i * blocksize;
                int end = Math.min(n + blocksize, size);
                BlockArrayRunner run = new BlockArrayRunner(aids, n, end, procs);
                parts.add(core.submit(run));
            }
            for (Future future : parts) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Processor execution failed.", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Parallel execution interrupted.");
        }
        finally {
            core.disconnect();
        }
    }

    protected static class BlockArrayRunner
    implements Callable<ArrayDBIDs>,
    Executor {
        private ArrayDBIDs ids;
        private int start;
        private int end;
        private Processor[] procs;
        private HashMap<SharedVariable<?>, SharedVariable.Instance<?>> variables = new HashMap();

        protected BlockArrayRunner(ArrayDBIDs ids, int start, int end, Processor[] procs) {
            this.ids = ids;
            this.start = start;
            this.end = end;
            this.procs = procs;
        }

        @Override
        public ArrayDBIDs call() {
            Processor.Instance[] instances = new Processor.Instance[this.procs.length];
            for (int i = 0; i < this.procs.length; ++i) {
                instances[i] = this.procs[i].instantiate(this);
            }
            DBIDArrayIter iter = this.ids.iter().seek(this.start);
            while (iter.valid() && iter.getOffset() < this.end) {
                for (int i = 0; i < instances.length; ++i) {
                    instances[i].map(iter);
                }
                iter.advance();
            }
            for (int i = 0; i < instances.length; ++i) {
                this.procs[i].cleanup(instances[i]);
            }
            return this.ids;
        }

        @Override
        public <I extends SharedVariable.Instance<?>> I getInstance(SharedVariable<I> parent) {
            SharedVariable.Instance<Object> inst = this.variables.get(parent);
            if (inst == null) {
                inst = parent.instantiate();
                this.variables.put(parent, inst);
            }
            return (I)inst;
        }
    }
}

