/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.parallel;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.Processor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedVariable;
import java.util.HashMap;

public final class SingleThreadedExecutor {
    private SingleThreadedExecutor() {
    }

    public static void run(DBIDs ids, Processor ... procs) {
        new SingleThreadedRunner(ids, procs).run();
    }

    protected static class SingleThreadedRunner
    implements Executor {
        private DBIDs ids;
        private Processor[] procs;
        private HashMap<SharedVariable<?>, SharedVariable.Instance<?>> variables = new HashMap();

        protected SingleThreadedRunner(DBIDs ids, Processor[] procs) {
            this.ids = ids;
            this.procs = procs;
        }

        public void run() {
            Processor.Instance[] instances = new Processor.Instance[this.procs.length];
            for (int i = 0; i < this.procs.length; ++i) {
                instances[i] = this.procs[i].instantiate(this);
            }
            DBIDIter iter = this.ids.iter();
            while (iter.valid()) {
                for (int i = 0; i < instances.length; ++i) {
                    instances[i].map(iter);
                }
                iter.advance();
            }
            for (int i = 0; i < instances.length; ++i) {
                this.procs[i].cleanup(instances[i]);
            }
        }

        @Override
        public <I extends SharedVariable.Instance<?>> I getInstance(SharedVariable<I> parent) {
            SharedVariable.Instance<Object> inst = this.variables.get(parent);
            if (inst == null) {
                inst = parent.instantiate();
                this.variables.put(parent, inst);
            }
            return (I)inst;
        }
    }
}

