/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.parallel.processor;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.Processor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedDouble;

public class DoubleMinMaxProcessor
implements Processor {
    DoubleMinMax minmax = new DoubleMinMax();
    SharedDouble input;

    public void connectInput(SharedDouble input) {
        this.input = input;
    }

    @Override
    public Instance instantiate(Executor executor) {
        return new Instance(executor.getInstance(this.input));
    }

    @Override
    public void cleanup(Processor.Instance inst) {
        this.merge(((Instance)inst).minmax);
    }

    protected synchronized void merge(DoubleMinMax minmax) {
        this.minmax.put(minmax.getMin());
        this.minmax.put(minmax.getMax());
    }

    public DoubleMinMax getMinMax() {
        return this.minmax;
    }

    private static class Instance
    implements Processor.Instance {
        private DoubleMinMax minmax = new DoubleMinMax();
        private SharedDouble.Instance input;

        public Instance(SharedDouble.Instance input) {
            this.input = input;
        }

        @Override
        public void map(DBIDRef id) {
            this.minmax.put(this.input.doubleValue());
        }
    }
}

