/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.parallel.processor;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.Processor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedObject;

public class KNNProcessor<O>
implements Processor {
    int k;
    KNNQuery<O> knnq;
    SharedObject<KNNList> out;

    public KNNProcessor(int k, KNNQuery<O> knnq) {
        this.k = k;
        this.knnq = knnq;
    }

    public void connectKNNOutput(SharedObject<KNNList> output) {
        this.out = output;
    }

    @Override
    public Instance<O> instantiate(Executor executor) {
        return new Instance<O>(this.k, this.knnq, (SharedObject.Instance)((Object)executor.getInstance(this.out)));
    }

    @Override
    public void cleanup(Processor.Instance inst) {
    }

    public static class Instance<O>
    implements Processor.Instance {
        int k;
        KNNQuery<O> knnq;
        SharedObject.Instance<KNNList> out;

        protected Instance(int k, KNNQuery<O> knnq, SharedObject.Instance<KNNList> out) {
            this.k = k;
            this.knnq = knnq;
            this.out = out;
        }

        @Override
        public void map(DBIDRef id) {
            this.out.set(this.knnq.getKNNForDBID(id, this.k));
        }
    }
}

