/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.persistent.AbstractPageFile;
import de.lmu.ifi.dbs.elki.persistent.Page;
import de.lmu.ifi.dbs.elki.persistent.PageHeader;
import java.util.Stack;

public abstract class AbstractStoringPageFile<P extends Page>
extends AbstractPageFile<P> {
    protected Stack<Integer> emptyPages = new Stack();
    protected int nextPageID = 0;
    protected int pageSize;

    protected AbstractStoringPageFile(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public int setPageID(P page) {
        int pageID = page.getPageID();
        if (pageID == -1) {
            pageID = this.getNextEmptyPageID();
            if (pageID == -1) {
                pageID = this.nextPageID++;
            }
            page.setPageID(pageID);
        }
        return pageID;
    }

    @Override
    public void deletePage(int pageID) {
        this.emptyPages.push(pageID);
    }

    private int getNextEmptyPageID() {
        if (!this.emptyPages.empty()) {
            return this.emptyPages.pop();
        }
        return -1;
    }

    @Override
    public int getNextPageID() {
        return this.nextPageID;
    }

    @Override
    public void setNextPageID(int nextPageID) {
        this.nextPageID = nextPageID;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean initialize(PageHeader header) {
        this.pageSize = header.getPageSize();
        return false;
    }

    @Override
    public void logStatistics() {
        super.logStatistics();
        if (this.getLogger().isStatistics()) {
            this.getLogger().statistics(new LongStatistic(this.getClass().getName() + ".numpages", this.nextPageID - this.emptyPages.size()));
        }
    }
}

