/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.persistent.PageHeader;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DefaultPageHeader
implements PageHeader {
    private static final int SIZE = 8;
    private static final int FILE_VERSION = 841150978;
    private int pageSize = -1;

    public DefaultPageHeader() {
    }

    public DefaultPageHeader(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public int size() {
        return 8;
    }

    @Override
    public void readHeader(RandomAccessFile file) throws IOException {
        file.seek(0L);
        if (file.readInt() != 841150978) {
            throw new RuntimeException("File " + file + " is not a PersistentPageFile or wrong version!");
        }
        this.pageSize = file.readInt();
    }

    @Override
    public void readHeader(byte[] data) {
        if (ByteArrayUtil.readInt(data, 0) != 841150978) {
            throw new RuntimeException("PersistentPageFile version does not match!");
        }
        this.pageSize = ByteArrayUtil.readInt(data, 4);
    }

    @Override
    public void writeHeader(RandomAccessFile file) throws IOException {
        file.seek(0L);
        file.writeInt(841150978);
        file.writeInt(this.pageSize);
    }

    @Override
    public byte[] asByteArray() {
        byte[] header = new byte[8];
        ByteArrayUtil.writeInt(header, 0, 841150978);
        ByteArrayUtil.writeInt(header, 4, this.pageSize);
        return header;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getReservedPages() {
        return this.size() / this.getPageSize() + 1;
    }
}

