/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.AbstractPageFile;
import de.lmu.ifi.dbs.elki.persistent.Page;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.persistent.PageHeader;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<P extends Page>
extends AbstractPageFile<P> {
    private static final Logging LOG = Logging.getLogger(LRUCache.class);
    protected int cacheSizeBytes;
    protected int cacheSize;
    private LinkedHashMap<Integer, P> map;
    protected PageFile<P> file;

    public LRUCache(int cacheSizeBytes, PageFile<P> file) {
        this.file = file;
        this.cacheSizeBytes = cacheSizeBytes;
    }

    @Override
    public synchronized P readPage(int pageID) {
        this.countRead();
        Page page = (Page)this.map.get(pageID);
        if (page != null) {
            if (LOG.isDebuggingFine()) {
                LOG.debugFine("Read from cache: " + pageID);
            }
        } else {
            if (LOG.isDebuggingFine()) {
                LOG.debugFine("Read from backing: " + pageID);
            }
            page = this.file.readPage(pageID);
            this.map.put(pageID, page);
        }
        return (P)page;
    }

    @Override
    public synchronized void writePage(int pageID, P page) {
        this.countWrite();
        page.setDirty(true);
        this.map.put(pageID, page);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Write to cache: " + pageID);
        }
    }

    @Override
    public void deletePage(int pageID) {
        this.countWrite();
        this.map.remove(pageID);
        this.file.deletePage(pageID);
    }

    protected void expirePage(P page) {
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Write to backing:" + page.getPageID());
        }
        if (page.isDirty()) {
            this.file.writePage(page);
        }
    }

    @Override
    public int setPageID(P page) {
        int pageID = this.file.setPageID(page);
        return pageID;
    }

    @Override
    public int getNextPageID() {
        return this.file.getNextPageID();
    }

    @Override
    public void setNextPageID(int nextPageID) {
        this.file.setNextPageID(nextPageID);
    }

    @Override
    public int getPageSize() {
        return this.file.getPageSize();
    }

    @Override
    public boolean initialize(PageHeader header) {
        boolean created = this.file.initialize(header);
        this.cacheSize = this.cacheSizeBytes / header.getPageSize();
        if (this.cacheSize <= 0) {
            throw new AbortException("Invalid cache size: " + this.cacheSizeBytes + " / " + header.getPageSize() + " = " + this.cacheSize);
        }
        if (LOG.isDebugging()) {
            LOG.debug("LRU cache size is " + this.cacheSize + " pages.");
        }
        float hashTableLoadFactor = 0.75f;
        int hashTableCapacity = (int)Math.ceil((float)this.cacheSize / hashTableLoadFactor) + 1;
        this.map = new LinkedHashMap<Integer, P>(hashTableCapacity, hashTableLoadFactor, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, P> eldest) {
                if (this.size() > LRUCache.this.cacheSize) {
                    LRUCache.this.expirePage((Page)eldest.getValue());
                    return true;
                }
                return false;
            }
        };
        return created;
    }

    @Override
    public void close() {
        this.flush();
        this.file.close();
    }

    public void flush() {
        for (Page object : this.map.values()) {
            this.expirePage(object);
        }
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        long toDelete = this.map.size() - this.cacheSize;
        if (toDelete <= 0L) {
            return;
        }
        ArrayList<Integer> keys = new ArrayList<Integer>(this.map.keySet());
        Collections.reverse(keys);
        for (Integer id : keys) {
            Page page = (Page)this.map.remove(id);
            this.file.writePage(page);
        }
    }

    @Override
    public void logStatistics() {
        super.logStatistics();
        this.file.logStatistics();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

