/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class OnDiskArray
implements AutoCloseable {
    private static final long serialVersionUID = 7586497243452875056L;
    protected int magic;
    private int headersize;
    private int recordsize;
    private int numrecs;
    private File filename;
    private final RandomAccessFile file;
    private FileLock lock = null;
    private boolean writable;
    private MappedByteBuffer map;
    private static final int INTERNAL_HEADER_SIZE = 16;
    private static final int HEADER_POS_SIZE = 12;

    public OnDiskArray(File filename, int magicseed, int extraheadersize, int recordsize, int initialsize) throws IOException {
        this.magic = OnDiskArray.mixMagic(1165828400, magicseed);
        this.headersize = extraheadersize + 16;
        this.recordsize = recordsize;
        this.filename = filename;
        this.writable = true;
        if (filename.exists() && filename.length() > 0L) {
            throw new IOException("File already exists");
        }
        this.file = new RandomAccessFile(filename, "rw");
        this.lock = this.file.getChannel().lock();
        this.file.writeInt(this.magic);
        this.file.writeInt(this.headersize);
        this.file.writeInt(this.recordsize);
        if (this.file.getFilePointer() != 12L) {
            throw new IOException("File position doesn't match when writing file size.");
        }
        this.file.writeInt(initialsize);
        if (this.file.getFilePointer() != 16L) {
            throw new IOException("File position doesn't match header size after writing header.");
        }
        this.resizeFile(initialsize);
        this.mapArray();
    }

    public OnDiskArray(File filename, int magicseed, int extraheadersize, int recordsize, boolean writable) throws IOException {
        this.magic = OnDiskArray.mixMagic(1165828400, magicseed);
        this.headersize = extraheadersize + 16;
        this.recordsize = recordsize;
        this.filename = filename;
        this.writable = writable;
        String mode = writable ? "rw" : "r";
        this.file = new RandomAccessFile(filename, mode);
        if (writable) {
            this.lock = this.file.getChannel().lock();
        }
        this.validateHeader(true);
        this.mapArray();
    }

    public OnDiskArray(File filename, int magicseed, int extraheadersize, boolean writable) throws IOException {
        this.magic = OnDiskArray.mixMagic(1165828400, magicseed);
        this.headersize = extraheadersize + 16;
        this.filename = filename;
        this.writable = writable;
        String mode = writable ? "rw" : "r";
        this.file = new RandomAccessFile(filename, mode);
        if (writable) {
            this.lock = this.file.getChannel().lock();
        }
        this.validateHeader(false);
        this.mapArray();
    }

    private synchronized void mapArray() throws IOException {
        if (this.map != null) {
            ByteArrayUtil.unmapByteBuffer(this.map);
            this.map = null;
        }
        FileChannel.MapMode mode = this.writable ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY;
        this.map = this.file.getChannel().map(mode, this.headersize, this.recordsize * this.numrecs);
    }

    private void validateHeader(boolean validateRecordSize) throws IOException {
        int readmagic = this.file.readInt();
        if (readmagic != this.magic) {
            this.file.close();
            throw new IOException("Magic in LinearDiskCache does not match: " + readmagic + " instead of " + this.magic);
        }
        if (this.file.readInt() != this.headersize) {
            this.file.close();
            throw new IOException("Header size in LinearDiskCache does not match.");
        }
        if (validateRecordSize) {
            if (this.file.readInt() != this.recordsize) {
                this.file.close();
                throw new IOException("Recordsize in LinearDiskCache does not match.");
            }
        } else {
            this.recordsize = this.file.readInt();
        }
        if (this.file.getFilePointer() != 12L) {
            throw new IOException("Incorrect file position when reading header.");
        }
        this.numrecs = this.file.readInt();
        if (this.numrecs < 0 || this.file.length() != this.indexToFileposition(this.numrecs)) {
            throw new IOException("File size and number of records do not agree.");
        }
        if (this.file.getFilePointer() != 16L) {
            throw new IOException("Incorrect file position after reading header.");
        }
    }

    public static final int mixMagic(int magic1, int magic2) {
        long prime = 2654435761L;
        long result = 1L;
        result = 2654435761L * result + (long)magic1;
        result = 2654435761L * result + (long)magic2;
        return (int)result;
    }

    private long indexToFileposition(long index) {
        long pos = (long)this.headersize + index * (long)this.recordsize;
        return pos;
    }

    public synchronized void resizeFile(int newsize) throws IOException {
        if (!this.writable) {
            throw new IOException("File is not writeable!");
        }
        this.numrecs = newsize;
        this.file.seek(12L);
        this.file.writeInt(this.numrecs);
        this.file.setLength(this.indexToFileposition(this.numrecs));
        this.mapArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ByteBuffer getRecordBuffer(int index) throws IOException {
        if (index < 0 || index >= this.numrecs) {
            throw new IOException("Access beyond end of file.");
        }
        MappedByteBuffer mappedByteBuffer = this.map;
        synchronized (mappedByteBuffer) {
            this.map.limit(this.recordsize * (index + 1));
            this.map.position(this.recordsize * index);
            return this.map.slice();
        }
    }

    protected int getExtraHeaderSize() {
        return this.headersize - 16;
    }

    public synchronized ByteBuffer getExtraHeader() throws IOException {
        int size = this.headersize - 16;
        FileChannel.MapMode mode = this.writable ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY;
        return this.file.getChannel().map(mode, 16L, size);
    }

    protected int getRecordsize() {
        return this.recordsize;
    }

    public File getFilename() {
        return this.filename;
    }

    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public synchronized void close() throws IOException {
        this.writable = false;
        if (this.map != null) {
            ByteArrayUtil.unmapByteBuffer(this.map);
            this.map = null;
        }
        if (this.lock != null) {
            this.lock.release();
            this.lock = null;
        }
        this.file.close();
    }

    public int getNumRecords() {
        return this.numrecs;
    }

    public void ensureSize(int size) throws IOException {
        if (size > this.getNumRecords()) {
            this.resizeFile(size);
        }
    }
}

