/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.persistent.AbstractStoringPageFile;
import de.lmu.ifi.dbs.elki.persistent.OnDiskArray;
import de.lmu.ifi.dbs.elki.persistent.Page;
import de.lmu.ifi.dbs.elki.persistent.PageHeader;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class OnDiskArrayPageFile<P extends Page>
extends AbstractStoringPageFile<P> {
    private static final Logging LOG = Logging.getLogger(OnDiskArrayPageFile.class);
    private static final int EMPTY_PAGE = 0;
    private static final int FILLED_PAGE = 1;
    private File filename;
    private OnDiskArray file;
    protected PageHeader header;
    private final boolean existed;

    public OnDiskArrayPageFile(int pageSize, String fileName) {
        super(pageSize);
        this.filename = new File(fileName);
        this.existed = this.filename.exists();
    }

    @Override
    public P readPage(int pageID) {
        try {
            this.countRead();
            return this.byteBufferToPage(this.file.getRecordBuffer(pageID));
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred during reading of page " + pageID, e);
        }
    }

    @Override
    public void deletePage(int pageID) {
        try {
            super.deletePage(pageID);
            this.countWrite();
            byte[] array = this.pageToByteArray(null);
            this.file.getRecordBuffer(pageID).put(array);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writePage(int pageID, P page) {
        if (page.isDirty()) {
            try {
                this.countWrite();
                byte[] array = this.pageToByteArray(page);
                this.file.getRecordBuffer(pageID).put(array);
                page.setDirty(false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() {
        try {
            super.close();
            this.file.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.file.resizeFile(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private P byteBufferToPage(ByteBuffer buffer) {
        try (ByteBufferInputStream bais = new ByteBufferInputStream(buffer);){
            int type;
            Throwable throwable;
            ObjectInputStream ois;
            block33: {
                Page page;
                block34: {
                    block31: {
                        P p;
                        block32: {
                            ois = new ObjectInputStream(bais);
                            throwable = null;
                            type = ois.readInt();
                            if (type != 0) break block31;
                            p = null;
                            if (ois == null) return p;
                            if (throwable == null) break block32;
                            try {
                                ois.close();
                                return p;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return p;
                            }
                        }
                        ois.close();
                        return p;
                    }
                    if (type != 1) break block33;
                    page = (Page)ois.readObject();
                    if (ois == null) return (P)page;
                    if (throwable == null) break block34;
                    try {
                        ois.close();
                        return (P)page;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                        return (P)page;
                    }
                }
                ois.close();
                return (P)page;
            }
            try {
                try {
                    throw new IllegalArgumentException("Unknown type: " + type);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                if (ois == null) throw throwable5;
                if (throwable == null) {
                    ois.close();
                    throw throwable5;
                }
                try {
                    ois.close();
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throwable.addSuppressed(throwable6);
                    throw throwable5;
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LoggingUtil.exception(e);
            return null;
        }
    }

    private byte[] pageToByteArray(P page) {
        try {
            if (page == null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeInt(0);
                oos.close();
                baos.close();
                byte[] array = baos.toByteArray();
                byte[] result = new byte[this.pageSize];
                System.arraycopy(array, 0, result, 0, array.length);
                return result;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeInt(1);
            oos.writeObject(page);
            oos.close();
            baos.close();
            byte[] array = baos.toByteArray();
            if (array.length > this.pageSize) {
                throw new IllegalArgumentException("Size of page " + page + " is greater than specified pagesize: " + array.length + " > " + this.pageSize);
            }
            if (array.length == this.pageSize) {
                return array;
            }
            byte[] result = new byte[this.pageSize];
            System.arraycopy(array, 0, result, 0, array.length);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred! ", e);
        }
    }

    @Override
    public boolean initialize(PageHeader header) {
        this.header = header;
        try {
            if (this.existed) {
                LoggingUtil.logExpensive(Level.INFO, "Create from existing file.");
                this.file = new OnDiskArray(this.filename, 0, header.size(), this.pageSize, true);
                ByteBuffer buffer = this.file.getExtraHeader();
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                header.readHeader(bytes);
                for (int i = 0; i < this.file.getNumRecords(); ++i) {
                    ByteBuffer buffer2 = this.file.getRecordBuffer(i);
                    int type = buffer2.getInt();
                    if (type == 0) {
                        this.emptyPages.push(i);
                    } else if (type == 1) {
                        this.nextPageID = i + 1;
                    } else {
                        throw new IllegalArgumentException("Unknown type: " + type);
                    }
                    ++i;
                }
                return true;
            }
            LoggingUtil.logExpensive(Level.INFO, "Create a new file.");
            this.file = new OnDiskArray(this.filename, 0, header.size(), this.pageSize, 0);
            ByteBuffer buffer = this.file.getExtraHeader();
            buffer.put(header.asByteArray());
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred.", e);
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

