/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.persistent.AbstractPageFileFactory;
import de.lmu.ifi.dbs.elki.persistent.OnDiskArrayPageFile;
import de.lmu.ifi.dbs.elki.persistent.Page;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.io.File;

public class OnDiskArrayPageFileFactory<P extends Page>
extends AbstractPageFileFactory<P> {
    private String fileName;

    public OnDiskArrayPageFileFactory(int pageSize, String fileName) {
        super(pageSize);
        this.fileName = fileName;
    }

    @Override
    public PageFile<P> newPageFile(Class<P> cls) {
        if (this.fileName == null) {
            throw new AbortException("Disk-backed page file may only be instantiated once!");
        }
        OnDiskArrayPageFile pfile = new OnDiskArrayPageFile(this.pageSize, this.fileName);
        this.fileName = null;
        return pfile;
    }

    public static class Parameterizer
    extends AbstractPageFileFactory.Parameterizer<Page> {
        private String fileName;
        public static final OptionID FILE_ID = new OptionID("pagefile.file", "The name of the file storing the page file.");

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            FileParameter fileNameP = new FileParameter(FILE_ID, FileParameter.FileType.OUTPUT_FILE);
            if (config.grab(fileNameP)) {
                this.fileName = ((File)fileNameP.getValue()).getPath();
            }
        }

        @Override
        protected OnDiskArrayPageFileFactory<Page> makeInstance() {
            return new OnDiskArrayPageFileFactory<Page>(this.pageSize, this.fileName);
        }
    }
}

