/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.persistent.OnDiskArray;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OnDiskUpperTriangleMatrix
implements AutoCloseable {
    private static final long serialVersionUID = -4489942156357634702L;
    private static final int TRIANGLE_HEADER_SIZE = 4;
    private int matrixsize;
    private OnDiskArray array;

    public OnDiskUpperTriangleMatrix(File filename, int magicseed, int extraheadersize, int recordsize, boolean writable) throws IOException {
        this.array = new OnDiskArray(filename, OnDiskArray.mixMagic(-1002408590, magicseed), extraheadersize + 4, recordsize, writable);
        ByteBuffer header = this.array.getExtraHeader();
        this.matrixsize = header.getInt();
        if (OnDiskUpperTriangleMatrix.arraysize(this.matrixsize) != this.array.getNumRecords()) {
            throw new IOException("Matrix file size doesn't match specified dimensions: " + this.matrixsize + "->" + OnDiskUpperTriangleMatrix.arraysize(this.matrixsize) + " vs. " + this.array.getNumRecords());
        }
    }

    public OnDiskUpperTriangleMatrix(File filename, int magicseed, int extraheadersize, int recordsize, int matrixsize) throws IOException {
        if (matrixsize >= 65535) {
            throw new RuntimeException("Matrix size is too big and will overflow the integer datatype.");
        }
        this.matrixsize = matrixsize;
        this.array = new OnDiskArray(filename, OnDiskArray.mixMagic(-1002408590, magicseed), extraheadersize + 4, recordsize, OnDiskUpperTriangleMatrix.arraysize(matrixsize));
        ByteBuffer header = this.array.getExtraHeader();
        header.putInt(this.matrixsize);
    }

    public synchronized void resizeMatrix(int newsize) throws IOException {
        if (newsize >= 65535) {
            throw new RuntimeException("Matrix size is too big and will overflow the integer datatype.");
        }
        if (!this.array.isWritable()) {
            throw new IOException("Can't resize a read-only array.");
        }
        this.array.resizeFile(OnDiskUpperTriangleMatrix.arraysize(newsize));
        this.matrixsize = newsize;
        ByteBuffer header = this.array.getExtraHeader();
        header.putInt(this.matrixsize);
    }

    private static int arraysize(int matrixsize) {
        return matrixsize * (matrixsize + 1) >> 1;
    }

    private int computeOffset(int x, int y) {
        if (y > x) {
            return this.computeOffset(y, x);
        }
        return (x * (x + 1) >> 1) + y;
    }

    public synchronized ByteBuffer getRecordBuffer(int x, int y) throws IOException {
        if (x >= this.matrixsize || y >= this.matrixsize) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array.getRecordBuffer(this.computeOffset(x, y));
    }

    @Override
    public synchronized void close() throws IOException {
        this.array.close();
    }

    public int getMatrixSize() {
        return this.matrixsize;
    }
}

