/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.index.tree.TreeIndexHeader;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.AbstractStoringPageFile;
import de.lmu.ifi.dbs.elki.persistent.ExternalizablePage;
import de.lmu.ifi.dbs.elki.persistent.PageHeader;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;

public class PersistentPageFile<P extends ExternalizablePage>
extends AbstractStoringPageFile<P> {
    private static final Logging LOG = Logging.getLogger(PersistentPageFile.class);
    private static final int EMPTY_PAGE = 0;
    private static final int FILLED_PAGE = 1;
    private final RandomAccessFile file;
    protected PageHeader header;
    protected final Class<P> pageclass;
    private boolean existed;

    public PersistentPageFile(int pageSize, String fileName, Class<P> pageclass) {
        super(pageSize);
        this.pageclass = pageclass;
        File f = new File(fileName);
        this.existed = f.exists();
        try {
            this.file = new RandomAccessFile(f, "rw");
        }
        catch (IOException e) {
            throw new AbortException("IO error in loading persistent page file.", e);
        }
    }

    @Override
    public P readPage(int pageID) {
        try {
            this.countRead();
            long offset = (long)(this.header.getReservedPages() + pageID) * (long)this.pageSize;
            byte[] buffer = new byte[this.pageSize];
            this.file.seek(offset);
            this.file.read(buffer);
            return this.byteArrayToPage(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred during reading of page " + pageID + "\n", e);
        }
    }

    @Override
    public void deletePage(int pageID) {
        try {
            super.deletePage(pageID);
            this.countWrite();
            byte[] array = this.pageToByteArray(null);
            long offset = (long)(this.header.getReservedPages() + pageID) * (long)this.pageSize;
            this.file.seek(offset);
            this.file.write(array);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writePage(int pageID, P page) {
        try {
            this.countWrite();
            byte[] array = this.pageToByteArray(page);
            long offset = (long)(this.header.getReservedPages() + pageID) * (long)this.pageSize;
            assert (offset >= 0L) : this.header.getReservedPages() + " " + pageID + " " + this.pageSize + " " + offset;
            this.file.seek(offset);
            this.file.write(array);
            page.setDirty(false);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing to page file.", e);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
            if (!this.emptyPages.isEmpty() && this.header instanceof TreeIndexHeader) {
                ((TreeIndexHeader)this.header).writeEmptyPages(this.emptyPages, this.file);
            }
            ((TreeIndexHeader)this.header).setLargestPageID(this.nextPageID);
            this.header.writeHeader(this.file);
            this.file.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.file.setLength(this.header.size());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private P byteArrayToPage(byte[] array) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(array);
            ObjectInputStream ois = new ObjectInputStream(bais);
            int type = ois.readInt();
            if (type == 0) {
                return null;
            }
            if (type == 1) {
                ExternalizablePage page;
                try {
                    page = (ExternalizablePage)this.pageclass.newInstance();
                    page.readExternal(ois);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new AbortException("Error instanciating an index page", e);
                }
                return (P)page;
            }
            throw new IllegalArgumentException("Unknown type: " + type);
        }
        catch (IOException e) {
            throw new AbortException("IO Error in page file", e);
        }
    }

    private byte[] pageToByteArray(P page) {
        try {
            if (page == null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeInt(0);
                oos.close();
                baos.close();
                byte[] array = baos.toByteArray();
                byte[] result = new byte[this.pageSize];
                System.arraycopy(array, 0, result, 0, array.length);
                return result;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeInt(1);
            page.writeExternal(oos);
            oos.close();
            baos.close();
            byte[] array = baos.toByteArray();
            if (array.length > this.pageSize) {
                throw new IllegalArgumentException("Size of page " + page + " is greater than specified pagesize: " + array.length + " > " + this.pageSize);
            }
            if (array.length == this.pageSize) {
                return array;
            }
            byte[] result = new byte[this.pageSize];
            System.arraycopy(array, 0, result, 0, array.length);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred! ", e);
        }
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    public PageHeader getHeader() {
        return this.header;
    }

    @Override
    public void setNextPageID(int next_page_id) {
        this.nextPageID = next_page_id;
        while (!this.emptyPages.isEmpty() && (Integer)this.emptyPages.peek() >= this.nextPageID) {
            this.emptyPages.pop();
        }
    }

    @Override
    public boolean initialize(PageHeader header) {
        block11: {
            try {
                if (this.existed) {
                    LOG.debug("Initializing from an existing page file.");
                    this.header = header;
                    header.readHeader(this.file);
                    if (header instanceof TreeIndexHeader) {
                        TreeIndexHeader tiHeader = (TreeIndexHeader)header;
                        this.nextPageID = tiHeader.getLargestPageID();
                        try {
                            this.emptyPages = tiHeader.readEmptyPages(this.file);
                            break block11;
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException("ClassNotFoundException occurred when reading empty pages.", e);
                        }
                    }
                    int i = 0;
                    while (this.file.getFilePointer() + (long)this.pageSize <= this.file.length()) {
                        long offset = (long)(header.getReservedPages() + i) * (long)this.pageSize;
                        byte[] buffer = new byte[this.pageSize];
                        this.file.seek(offset);
                        this.file.read(buffer);
                        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                        ObjectInputStream ois = new ObjectInputStream(bais);
                        int type = ois.readInt();
                        if (type == 0) {
                            this.emptyPages.push(i);
                        } else if (type == 1) {
                            this.nextPageID = i + 1;
                        } else {
                            throw new IllegalArgumentException("Unknown type: " + type);
                        }
                        ++i;
                    }
                    break block11;
                }
                LOG.debug("Initializing with a new page file.");
                this.header = header;
                header.writeHeader(this.file);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException occurred.", e);
            }
        }
        return this.existed;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

