/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.gui.GUIUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.VisualizerParameterizer;
import de.lmu.ifi.dbs.elki.visualization.gui.ResultWindow;
import javax.swing.SwingUtilities;

@Alias(value={"visualizer", "vis", "ResultVisualizer", "de.lmu.ifi.dbs.elki.visualization.gui.ResultVisualizer"})
@Priority(value=105)
public class AutomaticVisualization
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(AutomaticVisualization.class);
    String title;
    protected static final String DEFAULT_TITLE = "ELKI Result Visualization";
    VisualizerParameterizer manager;
    boolean single;
    ResultWindow window;

    public AutomaticVisualization(String title, VisualizerParameterizer manager, boolean single) {
        this.title = title;
        this.manager = manager;
        this.single = single;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        if (this.window == null) {
            if (this.title == null) {
                this.title = VisualizerParameterizer.getTitle(ResultUtil.findDatabase(hier), result);
                if (this.title == null) {
                    this.title = DEFAULT_TITLE;
                }
            }
            GUIUtil.setLookAndFeel();
            VisualizerContext context = this.manager.newContext(hier, result);
            this.window = new ResultWindow(this.title, context, this.single);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AutomaticVisualization.this.window.setVisible(true);
                    AutomaticVisualization.this.window.setExtendedState(AutomaticVisualization.this.window.getExtendedState() | 6);
                }
                catch (Throwable e) {
                    LOG.exception("Error in starting visualizer window.", e);
                }
            }
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID WINDOW_TITLE_ID = new OptionID("vis.window.title", "Title to use for visualization window.");
        public static final OptionID SINGLE_ID = new OptionID("vis.window.single", "Embed visualizers in a single window, not using thumbnails and detail views.");
        String title;
        VisualizerParameterizer manager;
        boolean single = false;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag singleF;
            super.makeOptions(config);
            StringParameter titleP = (StringParameter)new StringParameter(WINDOW_TITLE_ID).setOptional(true);
            if (config.grab(titleP)) {
                this.title = (String)titleP.getValue();
            }
            if (config.grab(singleF = new Flag(SINGLE_ID))) {
                this.single = singleF.isTrue();
            }
            this.manager = config.tryInstantiate(VisualizerParameterizer.class);
        }

        @Override
        protected AutomaticVisualization makeInstance() {
            return new AutomaticVisualization(this.title, this.manager, this.single);
        }
    }
}

