/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.HierarchicalResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class ClusteringVectorDumper
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(ClusteringVectorDumper.class);
    private File outputFile;
    private String forceLabel;
    private boolean append;

    public ClusteringVectorDumper(File outputFile, boolean append, String forceLabel) {
        this.outputFile = outputFile;
        this.forceLabel = forceLabel;
        this.append = append;
    }

    public ClusteringVectorDumper(File outputFile, boolean append) {
        this(outputFile, append, null);
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        List<Clustering<Model>> cs = Clustering.getClusteringResults(newResult);
        if (cs.isEmpty()) {
            return;
        }
        if (this.forceLabel != null && this.forceLabel.length() > 0 && cs.size() > 1) {
            LOG.warning("Found more than one clustering result, they will have the same (forced) label.");
        }
        if (this.outputFile != null) {
            try (FileOutputStream os = new FileOutputStream(this.outputFile, this.append);
                 PrintStream writer = new PrintStream(os);){
                for (Clustering<Model> c : cs) {
                    this.dumpClusteringOutput(writer, hier, c);
                }
                this.append = true;
            }
            catch (IOException e) {
                LOG.exception("Error writing to output stream.", e);
            }
        } else {
            for (Clustering<Model> c : cs) {
                this.dumpClusteringOutput(System.out, hier, c);
            }
        }
    }

    protected void dumpClusteringOutput(PrintStream writer, ResultHierarchy hierarchy, Clustering<?> c) {
        DBIDs pids;
        DBIDRange ids = null;
        It<HierarchicalResult> iter = hierarchy.iterParents(c).filter(Relation.class);
        while (iter.valid()) {
            pids = iter.get().getDBIDs();
            if (pids instanceof DBIDRange) {
                ids = (DBIDRange)pids;
                break;
            }
            LOG.warning("Parent result " + ((Relation)iter.get()).getLongName() + " has DBID type " + pids.getClass());
            iter.advance();
        }
        if (ids == null) {
            iter = hierarchy.iterAll().filter(Database.class);
            while (iter.valid()) {
                pids = ((Database)iter.get()).getRelation(TypeUtil.ANY, new Object[0]).getDBIDs();
                if (pids instanceof DBIDRange) {
                    ids = (DBIDRange)pids;
                    break;
                }
                LOG.warning("Parent result " + ((Database)iter.get()).getLongName() + " has DBID type " + pids.getClass());
                iter.advance();
            }
        }
        if (ids == null) {
            LOG.warning("Cannot dump cluster assignment, as I do not have a well-defined DBIDRange to use for a unique column assignment. DBIDs must be a continuous range.");
            return;
        }
        WritableIntegerDataStore map = DataStoreUtil.makeIntegerStorage(ids, 1);
        int cnum = 0;
        for (Cluster<?> clu : c.getAllClusters()) {
            DBIDIter iter2 = clu.getIDs().iter();
            while (iter2.valid()) {
                map.putInt(iter2, cnum);
                iter2.advance();
            }
            ++cnum;
        }
        DBIDArrayIter iter3 = ids.iter();
        while (iter3.valid()) {
            if (iter3.getOffset() > 0) {
                writer.append(' ');
            }
            writer.append(Integer.toString(map.intValue(iter3)));
            iter3.advance();
        }
        if (this.forceLabel != null) {
            if (this.forceLabel.length() > 0) {
                writer.append(' ').append(this.forceLabel);
            }
        } else {
            writer.append(' ').append(c.getLongName());
        }
        writer.append('\n');
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID OUT_ID = new OptionID("clustering.output", "Output file name. When not given, the result will be written to stdout.");
        public static final OptionID APPEND_ID = new OptionID("clustering.output.append", "Always append to the output file.");
        public static final OptionID FORCE_LABEL_ID = new OptionID("clustering.label", "Parameter to override the clustering label, mostly to give a more descriptive label.");
        private File outputFile = null;
        private String forceLabel;
        private boolean append;

        @Override
        protected void makeOptions(Parameterization config) {
            StringParameter labelP;
            Flag appendF;
            super.makeOptions(config);
            FileParameter outputP = (FileParameter)new FileParameter(OUT_ID, FileParameter.FileType.OUTPUT_FILE).setOptional(true);
            if (config.grab(outputP)) {
                this.outputFile = (File)outputP.getValue();
            }
            if (config.grab(appendF = new Flag(APPEND_ID))) {
                this.append = appendF.isTrue();
            }
            if (config.grab(labelP = (StringParameter)new StringParameter(FORCE_LABEL_ID).setOptional(true))) {
                this.forceLabel = (String)labelP.getValue();
            }
        }

        @Override
        protected ClusteringVectorDumper makeInstance() {
            return new ClusteringVectorDumper(this.outputFile, this.append, this.forceLabel);
        }
    }
}

