/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import java.util.ArrayList;
import java.util.Iterator;

public class EvaluationResult
extends BasicResult
implements TextWriteable,
Iterable<MeasurementGroup> {
    ArrayList<MeasurementGroup> groups = new ArrayList();
    ArrayList<String> header = new ArrayList();

    public EvaluationResult(String name, String shortname) {
        super(name, shortname);
    }

    public MeasurementGroup newGroup(String string) {
        MeasurementGroup g = new MeasurementGroup(string);
        this.groups.add(g);
        return g;
    }

    public MeasurementGroup findOrCreateGroup(String label) {
        for (MeasurementGroup g : this.groups) {
            if (!label.equals(g.getName())) continue;
            return g;
        }
        return this.newGroup(label);
    }

    @Override
    public void writeToText(TextWriterStream out, String label) {
        for (MeasurementGroup g : this.groups) {
            out.commentPrintLn(g.getName());
            out.flush();
            for (Measurement m : g) {
                out.inlinePrintNoQuotes(m.name);
                out.inlinePrintNoQuotes(m.val);
                out.flush();
            }
        }
    }

    public void addHeader(String line) {
        this.header.add(line);
    }

    public Iterable<String> getHeaderLines() {
        return this.header;
    }

    @Override
    public Iterator<MeasurementGroup> iterator() {
        return this.groups.iterator();
    }

    public int numLines() {
        int r = this.header.size();
        for (MeasurementGroup m : this.groups) {
            r += 1 + m.measurements.size();
        }
        return r;
    }

    public static EvaluationResult findOrCreate(ResultHierarchy hierarchy, Result parent, String name, String shortname) {
        ArrayList<EvaluationResult> ers = ResultUtil.filterResults(hierarchy, parent, EvaluationResult.class);
        EvaluationResult ev = null;
        for (EvaluationResult e : ers) {
            if (!shortname.equals(e.getShortName())) continue;
            ev = e;
            break;
        }
        if (ev == null) {
            ev = new EvaluationResult(name, shortname);
            hierarchy.add(parent, ev);
        }
        return ev;
    }

    public boolean visualizeSingleton() {
        return false;
    }

    public static class Measurement {
        String name;
        double val;
        double min;
        double max;
        double exp;
        private boolean lowerisbetter;

        protected Measurement(String name, double val, double min, double max, boolean lowerisbetter) {
            this(name, val, min, max, Double.NaN, lowerisbetter);
        }

        protected Measurement(String name, double val, double min, double max, double exp, boolean lowerisbetter) {
            this.name = name;
            this.val = val;
            this.min = min;
            this.max = max;
            this.exp = exp;
            this.lowerisbetter = lowerisbetter;
        }

        public String getName() {
            return this.name;
        }

        public double getVal() {
            return this.val;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getExp() {
            return this.exp;
        }

        public boolean lowerIsBetter() {
            return this.lowerisbetter;
        }
    }

    public static class MeasurementGroup
    implements Iterable<Measurement> {
        private String groupname;
        private ArrayList<Measurement> measurements = new ArrayList();

        protected MeasurementGroup(String gname) {
            this.groupname = gname;
        }

        public String getName() {
            return this.groupname;
        }

        public MeasurementGroup addMeasure(String name, double val, double min, double max, boolean lowerisbetter) {
            this.measurements.add(new Measurement(name, val, min, max, lowerisbetter));
            return this;
        }

        public MeasurementGroup addMeasure(String name, double val, double min, double max, double exp, boolean lowerisbetter) {
            this.measurements.add(new Measurement(name, val, min, max, exp, lowerisbetter));
            return this;
        }

        public boolean hasMeasure(String name) {
            for (Measurement m : this.measurements) {
                if (!m.name.equals(name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Measurement> iterator() {
            return this.measurements.iterator();
        }
    }
}

